package com.mobid.android.http.repository

import android.annotation.SuppressLint
import com.mobid.android.http.HttpClient
import com.mobid.android.http.HttpMethod.GET
import com.mobid.android.http.HttpMethod.POST
import com.mobid.android.http.RemoteResult
import com.mobid.android.http.isSuccess
import com.mobid.android.http.repository.API.provideImagePOST
import com.mobid.android.http.repository.API.provideVerificationGET
import com.mobid.android.http.repository.API.provideVerificationPOST
import com.mobid.android.model.ConferenceStatus
import org.json.JSONObject
import java.io.File

class MobIdRepository private constructor(){

    private var client = HttpClient()

    @SuppressLint("LogNotTimber")
    suspend fun verification(status: ConferenceStatus): RemoteResult<MobIdSession> {
        val input = JSONObject().put("status", status)
        return client.call(
            verb = POST,
            url = provideVerificationPOST(),
            input = input
        ).let {
            when {
                it.isSuccess() -> RemoteResult(data = MobIdSession.parse(it.data!!))
                else -> RemoteResult(remoteError = it.remoteError)
            }
        }
    }

    suspend fun checkStatus(verificationId: String, token: String): RemoteResult<MobIdSession> {
        val url = provideVerificationGET(verificationId)
        return client.call(
            verb = GET,
            url = url,
            token = token
        ).let {
            when {
                it.isSuccess() -> RemoteResult(data = MobIdSession.parse(it.data!!))
                else -> RemoteResult(remoteError = it.remoteError)
            }
        }
    }

    suspend fun uploadFile(verificationId: String, file: File, type: ConferenceStatus, token: String): RemoteResult<UploadImageResponse>{
        HttpPostMultipart(token).call(
                path = provideImagePOST(verificationId),
                verificationId = verificationId,
                status = type.outputId,
                file = file
        ).let {
            return when{
                it.isSuccess() -> RemoteResult(UploadImageResponse.parse(it.data))
                else -> RemoteResult(remoteError = it.remoteError)
            }
        }
    }

    companion object {
        private var instance: MobIdRepository? = null

        fun getInstance(): MobIdRepository {
            if(instance == null) instance = MobIdRepository()
            return instance!!

        }
    }
}