package com.mobid.android.http.repository

import com.mobid.android.model.ConferenceStatus
import com.mobid.android.utils.*
import org.json.JSONObject

data class MobIdSession(
    val verificationId: String?,
    val status: ConferenceStatus?,
    val isActive: Boolean?,
    val score: Score?,
    val documentData: String?,
    val createdAt: String?,
    val updatedAt: String?,
    val images: List<Any?>?, // todo need to add
    val conference: MobIdConference?,
    val token: String?
){
    companion object{
        fun parse(obj: JSONObject) = MobIdSession(
            verificationId = obj.getStringOrDef("verification_id"),
            status = obj.getStringOrDef("status")?.let { ConferenceStatus.parse(it) },
            isActive = obj.getBooleanOrDef("is_active"),
            documentData = obj.getStringOrDef("document_data"),
            createdAt = obj.getStringOrDef("created_at"),
            updatedAt = obj.getStringOrDef("updated_at"),
            conference = MobIdConference.parse(obj.getObjectSafe("conference")),
            score = Score.parse(obj.getObjectSafe("score")),
            images = obj.getJSONArray("images").toStringList(),
            token = obj.getStringOrDef("token")
        )
    }
}

data class Score(
    val score_id: String?,
    val document: Any?,
    val facial_match: Any?,
    val liveness: Any?,
    val isOcrRecognized:Any?
){

    companion object{
        fun parse(obj: JSONObject) = Score(
            score_id = obj.getStringOrDef("score_id"),
            document = obj.get("document"),
            facial_match = obj.get("facial_match"),
            liveness = obj.get("liveness"),
            isOcrRecognized = obj.get("is_ocr_recognized")
        )
    }
}

data class MobIdConference(
    val conferenceId: String?,
    val jitsiHost: String?,
    val jitsiRoom: String?,
    val createdAt: String?,
    val verification: Verification?
){
    companion object{
        fun parse(obj: JSONObject) = MobIdConference(
            conferenceId = obj.getStringOrDef("conference_id"),
            jitsiHost = obj.getStringOrDef("jitsi_host"),
            jitsiRoom = obj.getStringOrDef("jitsi_room"),
            createdAt = obj.getStringOrDef("created_at"),
            verification = Verification.parse(obj.getObjectSafe("verification"))
        )
    }
}

data class Verification(
    val verificationId: String?,
    val status: ConferenceStatus?
){
   companion object{
       fun parse(obj: JSONObject) = Verification(
           verificationId = obj.getStringOrDef("verification_id"),
           status = obj.getStringOrDef("status")?.let { ConferenceStatus.parse(it) }
       )
   }
}