package com.mobid.android.model

import androidx.annotation.StringRes
import com.mobid.android.R

enum class ConferenceStatus(val id: String, val outputId: String){

    UNKNOWN("UNKNOWN", "UNKNOWN"),
    WAIT_INVITE("WAIT_INVITE", "WAIT_INVITE"),
    CONFERENCE_START("CONFERENCE_START", "CONFERENCE_START"),
    SELFIE_1_START("SELFIE_1_START", "SELFIE"),
    SELFIE_2_START("SELFIE_2_START", "SELFIE"),
    DOCUMENTS_START("DOCUMENTS_START", "PASSPORT"),
    SELFIE_WITH_DOCUMENTS_START("SELFIE_WITH_DOCUMENTS_START", "SELFIE_WITH_PASSPORT"),
    CONFERENCE_STOPPED ("CONFERENCE_STOPPED", "CONFERENCE_STOPPED"),
    CONFERENCE_STOP ("CONFERENCE_STOP", "CONFERENCE_STOP");

    companion object {
        fun parse(name: String) = kotlin.runCatching {
            valueOf(name)
        }.getOrElse { UNKNOWN }
    }
}

fun ConferenceStatus.isComplete() =
        this == ConferenceStatus.CONFERENCE_STOP || this == ConferenceStatus.CONFERENCE_STOPPED

@StringRes
fun ConferenceStatus.provideButtonText(): Int =
    when(this){
        ConferenceStatus.SELFIE_1_START -> R.string.take_selfie
        ConferenceStatus.SELFIE_2_START -> R.string.take_selfie_again
        ConferenceStatus.DOCUMENTS_START-> R.string.take_document_photo
        ConferenceStatus.SELFIE_WITH_DOCUMENTS_START-> R.string.take_selfie_with_document
        ConferenceStatus.CONFERENCE_STOPPED -> R.string.complete
        ConferenceStatus.CONFERENCE_STOP -> R.string.complete
        else -> R.string.take_selfie
}