package com.mobid.android.utils

import android.Manifest
import android.app.Activity
import android.content.Context
import android.content.pm.PackageManager
import android.net.Uri
import android.util.Log
import android.view.View
import android.widget.Toast
import androidx.core.content.ContextCompat
import androidx.fragment.app.Fragment
import com.google.android.material.snackbar.Snackbar
import org.json.JSONArray
import org.json.JSONObject
import java.io.*
import java.lang.Exception

fun JSONArray.toStringList():List<String>{
    val listdata = mutableListOf<String>()
    for (i in 0 until this.length()) {
        listdata.add(this.getString(i))
    }
    return listdata
}

fun JSONObject.getStringOrDef(name: String, def: String? = null): String? = try{
    getString(name)
}catch (e: Exception) {
    def
}

fun JSONObject.getBooleanOrDef(name: String, def: Boolean? = null): Boolean? = try{
    getBoolean(name)
}catch (e: Exception){
    def
}

fun JSONObject.getObjectSafe(name: String) = kotlin.runCatching {
    getJSONObject(name)
}.getOrElse { JSONObject("{}") }

fun Activity.showError(toastMessage: String, errorLog: String? = null){
    Throwable(errorLog).printStackTrace()
    findViewById<View>(android.R.id.home)?.let{view ->
        Snackbar.make(view, toastMessage, Snackbar.LENGTH_LONG).show()
    }
}

fun Fragment.showError(toastMessage: String, errorLog: String? = null){
    Throwable(errorLog).printStackTrace()
    view?.let{view ->
        Snackbar.make(view, toastMessage, Snackbar.LENGTH_LONG).show()
    }
}

fun InputStream.getString(): String {

    var br: BufferedReader? = null
    val sb = StringBuilder()

    var line: String? = null
    try {

        br = BufferedReader(InputStreamReader(this, "UTF-8"))
        while ({ line = br.readLine(); line }() != null) {
            sb.append(line)
        }

    } catch (e: IOException) {
        e.printStackTrace()
    } finally {
        if (br != null) {
            try {
                br.close()
            } catch (e: IOException) {
                e.printStackTrace()
            }

        }
    }

    Log.d("Okhttp","${sb}")
    return sb.toString()
}

fun Uri.toRealFile(context: Context, cacheStorage: File) = if ("content" == this.scheme) {
    val inputStream = context.contentResolver.openInputStream(this)
    if (!cacheStorage.exists()) cacheStorage.mkdirs()
    val fileCopy = File(cacheStorage, "copy_${lastPathSegment}.jpeg")
    val fos = FileOutputStream(fileCopy)
    inputStream?.copyTo(fos)
    Uri.fromFile(File(fileCopy.path))
} else {
    this
}

fun Context.isGrantedCameraPerm() =
        ContextCompat.checkSelfPermission(this, Manifest.permission.CAMERA) == PackageManager.PERMISSION_GRANTED

fun Context.isGrantedMicroPerm() =
        ContextCompat.checkSelfPermission(this, Manifest.permission.CAMERA) == PackageManager.PERMISSION_GRANTED

fun Context.isGrantedStoragePerm() =
        ContextCompat.checkSelfPermission(this, Manifest.permission.READ_EXTERNAL_STORAGE) == PackageManager.PERMISSION_GRANTED
