package com.mobid.android.utils

import android.os.CountDownTimer
import com.mobid.android.http.isSuccess
import com.mobid.android.http.repository.MobIdRepository
import com.mobid.android.http.repository.MobIdSession
import kotlinx.coroutines.CoroutineScope
import kotlinx.coroutines.Dispatchers
import kotlinx.coroutines.launch

class StatusUpdater (
    private var sessionCallBack: ((MobIdSession) -> Unit)?,
    private val scope: CoroutineScope,
    private val repo: MobIdRepository,
    private val verificationId: String,
    private val token: String
) : CountDownTimer(INTERVAL, INTERVAL) {

    private var stopUpdate = false

    override fun onTick(millisUntilFinished: Long) = Unit

    override fun onFinish() {
        scope.launch(Dispatchers.IO) {
            val result = repo.checkStatus(verificationId, token )
            if (result.isSuccess())
                result.data?.let { res -> sessionCallBack?.invoke(res) }
            if (!stopUpdate)
                scope.launch(Dispatchers.Main) { super.start() }
        }
    }

    fun begin():StatusUpdater {
        super.start()
        stopUpdate = false
        return this
    }

    fun stop(){
        stopUpdate = true
        sessionCallBack = null
    }

    companion object {
        private val INTERVAL = 3_000L
    }
}