package com.mobid.android.view

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.FrameLayout
import androidx.fragment.app.Fragment
import com.facebook.react.modules.core.PermissionListener
import com.mobid.android.R
import org.jitsi.meet.sdk.JitsiMeetActivityInterface
import org.jitsi.meet.sdk.JitsiMeetConferenceOptions
import org.jitsi.meet.sdk.JitsiMeetView
import org.jitsi.meet.sdk.JitsiMeetViewListener
import java.net.URL

internal class ConferenceFragment: Fragment(), JitsiMeetActivityInterface, JitsiMeetViewListener {

    private var jitsiView: JitsiMeetView? = null

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? {
        return inflater.inflate(R.layout.activity_jitsi, container, false).also { view ->
            jitsiView = JitsiMeetView(requireContext())
            view.findViewById<FrameLayout>(R.id.container)
                .addView(
                    jitsiView,
                    0,
                    FrameLayout.LayoutParams(
                        FrameLayout.LayoutParams.MATCH_PARENT,
                        FrameLayout.LayoutParams.MATCH_PARENT
                    )
                )
        }
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        jitsiView?.join(
            JitsiMeetConferenceOptions
                .Builder()
                .setServerURL(URL(provideHost()))
                .setRoom(provideRoom())
                .setAudioMuted(false)
                .setVideoMuted(false)
                .setAudioOnly(false)
                .setFeatureFlag("call-integration.enabled", false)
                .build())
    }

    override fun onConferenceTerminated(p0: MutableMap<String, Any>?) = Unit
    override fun onConferenceJoined(p0: MutableMap<String, Any>?) = Unit
    override fun onConferenceWillJoin(p0: MutableMap<String, Any>?) = Unit
    override fun requestPermissions(p0: Array<out String>?, p1: Int, p2: PermissionListener?) = Unit

    override fun checkPermission(p0: String, p1: Int, p2: Int): Int =
        requireContext().checkPermission(p0, p1, p2)


    override fun checkSelfPermission(permission: String?): Int =
        requireContext().checkSelfPermission(permission?:"")

    override fun onDestroyView() {
        jitsiView?.dispose()
        super.onDestroyView()
    }

    companion object{

        private const val EXTRA_HOST = "EXTRA_SERVER_URL"
        private const val EXTRA_ROOM = "EXTRA_ROOM"

        private fun ConferenceFragment.provideHost() =
            (arguments?.getString(EXTRA_HOST)?:"").let {
                if (!it.startsWith("https://") || !it.startsWith("http://"))
                    "https://$it"
                else it
            }

        private fun ConferenceFragment.provideRoom() =
            arguments?.getString(EXTRA_ROOM)?:""

        fun getInstance(host: String, room: String) = ConferenceFragment().apply {
            arguments = Bundle()
            arguments?.putString(EXTRA_HOST, host)
            arguments?.putString(EXTRA_ROOM, room)
        }

    }
}