package com.mobid.android.view

import android.app.Activity
import android.os.Bundle
import androidx.fragment.app.FragmentActivity
import androidx.lifecycle.Observer
import com.facebook.react.modules.core.PermissionListener
import com.mobid.android.R
import com.mobid.android.SessionManager
import com.mobid.android.http.repository.MobIdSession
import com.mobid.android.model.ConferenceStatus
import org.jitsi.meet.sdk.JitsiMeetActivityInterface

internal class MobIdActivity: FragmentActivity(), JitsiMeetActivityInterface {

    private val sessionManager by lazy { SessionManager.init() }
    private var currentFragment: String? = null
    private var previousStatus: ConferenceStatus? = null

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.mobid_start)

        currentFragment = StartFragment::class.java.simpleName
        supportFragmentManager
            .beginTransaction()
            .add(R.id.fragment_container, StartFragment(), "startFragment")
            .commit()

        sessionManager.session.observe(this, Observer { checkStatus(it) })

    }

    private fun checkStatus(session: MobIdSession?){
        session?:return
        if(session.status == previousStatus) return
        previousStatus = session.status

        when(session.status){
            ConferenceStatus.CONFERENCE_START -> startConversation(session)
            ConferenceStatus.CONFERENCE_STOPPED,ConferenceStatus.CONFERENCE_STOP ->{
                sessionManager.stopObserving()
                setResult(Activity.RESULT_OK)
                finish()
            }
        }
    }

    private fun startConversation(session: MobIdSession){
        if(currentFragment == ConferenceFragment::class.simpleName) return

        val fragment = ConferenceFragment.getInstance(
            host = session.conference!!.jitsiHost!!,
            room = session.conference.jitsiRoom!!
        )

        currentFragment = ConferenceFragment::class.java.simpleName
        supportFragmentManager
            .beginTransaction()
            .replace(R.id.fragment_container, fragment, "Conversation Fragment")
            .commit()
    }

    override fun onDestroy() {
        sessionManager.clear()
        super.onDestroy()
    }

    override fun requestPermissions(p0: Array<out String>?, p1: Int, p2: PermissionListener?) = Unit

}