package com.mobid.android.view

import android.Manifest
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.Button
import android.widget.ProgressBar
import androidx.fragment.app.Fragment
import com.mobid.android.R
import com.mobid.android.SessionManager
import com.mobid.android.utils.isGrantedCameraPerm
import com.mobid.android.utils.isGrantedMicroPerm
import com.mobid.android.utils.showError

internal class StartFragment : Fragment(){

    private var progress: ProgressBar? = null
    private var buttonStart: Button? = null

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?
    ): View? = inflater.inflate(R.layout.activity_start, container, false)?.also { view ->
        progress = view.findViewById(R.id.progressBar)
        buttonStart = view.findViewById(R.id.buttonStart)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        buttonStart?.setOnClickListener { checkPermissionAndStart() }
    }

    private fun checkPermissionAndStart(){
        if(requireContext().isGrantedCameraPerm() && requireContext().isGrantedMicroPerm())
            startCall()
        else
            requestPermissions(
                arrayOf(Manifest.permission.CAMERA, Manifest.permission.RECORD_AUDIO),
                REQUEST_CODE_PERMISSIONS
            )
    }

    override fun onRequestPermissionsResult(requestCode: Int, permissions: Array<out String>, grantResults: IntArray) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults)
        if(requestCode == REQUEST_CODE_PERMISSIONS){
            when {
                !requireContext().isGrantedCameraPerm() && ! requireContext().isGrantedMicroPerm() ->
                    showError(getString(R.string.error_camera_micro_permission))
                !requireContext().isGrantedMicroPerm() ->
                    showError(getString(R.string.error_micro_permission))
                !requireContext().isGrantedCameraPerm() ->
                    showError(getString(R.string.error_camera_permission))
                else -> startCall()
            }
        }
    }

    private fun startCall() {
        SessionManager.init().startNewSession()
        progress?.visibility = View.VISIBLE
        buttonStart?.visibility = View.GONE
    }

    companion object{
        private const val REQUEST_CODE_PERMISSIONS = 1214
    }
}