package com.mobid.android.view.camera

import android.content.Context
import android.net.Uri
import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ImageView
import androidx.fragment.app.Fragment
import com.google.android.material.snackbar.Snackbar
import com.mobid.android.R

class PhotoPreviewFragment : Fragment(){

    private var fragmentBridge: CameraFragmentBridge? = null

    private val uri by lazy { provideUri() }

    override fun onAttach(context: Context) {
        super.onAttach(context)
        fragmentBridge = context as CameraFragmentBridge
    }

    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_photo, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        view.findViewById<ImageView>(R.id.imageView).setImageURI(uri)
        view.findViewById<View>(R.id.imageButtonCancel).setOnClickListener {
            fragmentBridge?.goBack()
        }
        view.findViewById<View>(R.id.imageButtonSave).setOnClickListener {
            fragmentBridge?.onComplete(uri)
        }
    }

    companion object{
        private const val EXTRA_IMAGE = "extra_image"

        private fun PhotoPreviewFragment.provideUri() =
                Uri.parse(arguments?.getString(EXTRA_IMAGE))

        fun getInstance(uri: Uri) = PhotoPreviewFragment().apply {
            arguments = Bundle()
            arguments?.putString(EXTRA_IMAGE, uri.toString())
        }
    }
}