/*
 * Decompiled with CFR 0.152.
 */
package ai.mrs.cli;

import ai.mrs.AbstractMasonsSDK;
import ai.mrs.session.CalleeSession;
import ai.mrs.session.CallerSession;
import ai.mrs.session.models.CreatingSessionOfCallee;
import ai.mrs.session.models.KnockFromCaller;
import ai.mrs.session.models.KnockResultToCaller;
import ai.mrs.session.models.ReplyToCaller;
import ai.mrs.session.models.UtteranceFromCaller;
import ai.mrs.utils.JsonUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.UUID;

public class Debugger {
    private AbstractMasonsSDK sdkRef;
    private String sessionIdRef;

    public Debugger(AbstractMasonsSDK sdkRef) {
        this.sdkRef = sdkRef;
    }

    public void run() {
        System.out.println("[Debug] Start");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            System.out.println("Commands:\n  exit\n  knock <Text>\n  send <Text>\n  reply <Text>\n");
            boolean flag = true;
            block16: while (flag) {
                String line = reader.readLine().trim();
                String[] argv = line.split(" ", 2);
                String cmd = argv[0];
                if (cmd.isEmpty()) continue;
                switch (cmd) {
                    case "knock": {
                        String text = argv[1];
                        String accountKey = "";
                        KnockFromCaller knock = new KnockFromCaller();
                        knock.setAccountKey(accountKey);
                        knock.setText(text);
                        KnockResultToCaller result = this.sdkRef.handleKnockFromCaller(knock);
                        if (null == result) {
                            System.out.println("[Debug] Knock Response: null");
                            continue block16;
                        }
                        System.out.println("[Debug] Knock Response: " + JsonUtil.objToJson(result));
                        if (!result.getSuccess().booleanValue()) continue block16;
                        this.createCalleeSession(text);
                        continue block16;
                    }
                    case "send": {
                        String text = argv[1];
                        CalleeSession session = this.sdkRef.getCalleeSessionBySessionID(this.sessionIdRef);
                        UtteranceFromCaller utterance = new UtteranceFromCaller(session, text);
                        ReplyToCaller reply = this.sdkRef.onReceivingUtteranceFromCaller(utterance);
                        if (null != reply && null != reply.getText() && !reply.getText().isEmpty()) {
                            System.out.println("[Reply] " + reply.getText());
                            if (!reply.getIsEnd().booleanValue()) continue block16;
                            System.out.println("[Debug] Session ended, " + this.sessionIdRef);
                            continue block16;
                        }
                        System.out.println("[Reply] null");
                        continue block16;
                    }
                    case "reply": {
                        ReplyToCaller reply;
                        UtteranceFromCaller utterance;
                        String text = argv[1];
                        CalleeSession session = this.sdkRef.getCalleeSessionBySessionID(this.sessionIdRef);
                        if (null == session) {
                            this.createCalleeSession(text);
                            session = this.sdkRef.getCalleeSessionBySessionID(this.sessionIdRef);
                        }
                        if (null != (reply = this.sdkRef.onReceivingUtteranceFromCaller(utterance = new UtteranceFromCaller(session, text)))) {
                            System.out.println("[Reply] " + reply.getText());
                            continue block16;
                        }
                        System.out.println("[Reply] null");
                        continue block16;
                    }
                    case "end": {
                        CalleeSession calleeSession;
                        String text = argv.length > 1 ? argv[1] : null;
                        CallerSession callerSession = this.sdkRef.getCallerSessionBySessionID(this.sessionIdRef);
                        if (null != callerSession) {
                            System.out.println("[Debug] Session ended, " + this.sessionIdRef);
                        }
                        if (null != (calleeSession = this.sdkRef.getCalleeSessionBySessionID(this.sessionIdRef))) {
                            calleeSession.exit(text);
                            System.out.println("[Debug] Session ended, " + this.sessionIdRef);
                        }
                        this.sessionIdRef = null;
                        continue block16;
                    }
                    case "exit": {
                        this.sdkRef.stop();
                        flag = false;
                        continue block16;
                    }
                }
                System.out.println("[Debug] Wrong command");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createCalleeSession(String text) {
        this.sessionIdRef = UUID.randomUUID().toString();
        System.out.println("[Debug] Session ID: " + this.sessionIdRef);
        CreatingSessionOfCallee creatingSessionOfCallee = new CreatingSessionOfCallee();
        String accountKeyRef = "tester";
        creatingSessionOfCallee.setAccountKey(accountKeyRef);
        creatingSessionOfCallee.setText(text);
        this.sdkRef.onCreatingSessionOfCallee(creatingSessionOfCallee);
    }
}

