/*
 * Decompiled with CFR 0.152.
 */
package ai.mrs.connection;

import ai.mrs.AbstractMasonsSDK;
import ai.mrs.MasonsSDKConfig;
import ai.mrs.connection.models.UtteranceResponse;
import ai.mrs.connection.utils.HTTPUtil;
import ai.mrs.mdp.MDPClient;
import ai.mrs.mdp.MDPHandler;
import ai.mrs.session.CalleeSession;
import ai.mrs.session.models.CreatingSessionOfCallee;
import ai.mrs.session.models.KnockFromCaller;
import ai.mrs.session.models.KnockResultToCaller;
import ai.mrs.session.models.ReplyFromCallee;
import ai.mrs.session.models.ReplyToCaller;
import ai.mrs.session.models.UtteranceFromCaller;
import ai.mrs.utils.JsonUtil;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;

public class MasonsConnection
implements MDPHandler {
    private String nodeID;
    private MDPClient mdpClient;
    private AbstractMasonsSDK sdk;
    private MasonsSDKConfig config;

    public MasonsConnection(AbstractMasonsSDK sdk, MasonsSDKConfig config) {
        this.config = config;
        this.sdk = sdk;
    }

    private void createNode(Map<String, String> headers, Proxy proxy) {
        String nodeUrl = this.config.getNodeUrl();
        String resp = HTTPUtil.post(nodeUrl, "", headers, proxy);
        Map respMap = JsonUtil.jsonToMap(resp);
        this.nodeID = (String)respMap.get("node_id");
    }

    public void start() {
        Map<String, String> connectHeaders;
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Access-Token", this.config.getAgentToken());
        Proxy proxy = this.config.getProxy();
        String proxyAuthorization = this.config.getProxyAuthorization();
        if (null != proxyAuthorization) {
            headers.put("Proxy-Authorization", proxyAuthorization);
        }
        if (null != (connectHeaders = this.config.getConnectHeaders())) {
            for (Map.Entry<String, String> entry : connectHeaders.entrySet()) {
                headers.put(entry.getKey(), entry.getValue());
            }
        }
        this.createNode(headers, proxy);
        headers.put("Sec-WebSocket-Protocol", "Duplex");
        headers.put("Node-ID", this.nodeID);
        this.mdpClient = new MDPClient(this.config.getWsUrl(), this, headers, this.config.getConnectTimeout(), this.config.getRpcTimeout(), proxy);
        this.mdpClient.connect();
    }

    public void stop() {
        this.mdpClient.close();
    }

    public Map callKnockEvent(Map data) {
        return this.mdpClient.callRPC("knock", data);
    }

    public UtteranceResponse callUtteranceEvent(String sessionID, String text) {
        HashMap<String, String> req = new HashMap<String, String>();
        req.put("session_id", sessionID);
        req.put("text", text);
        Map resp = this.mdpClient.callRPC("utterance", req);
        return JsonUtil.mapToObj(resp, UtteranceResponse.class);
    }

    public void sendReplyEvent(String sessionID, String text, boolean isEnd) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("session_id", sessionID);
        data.put("text", text);
        data.put("isEnd", isEnd);
        this.mdpClient.sendEvent("reply", data);
    }

    public void sendExitEvent(String sessionID, String text) {
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("session_id", sessionID);
        data.put("text", text);
        this.mdpClient.sendEvent("exit", data);
    }

    @Override
    public void processEventMessage(String event, Map data) {
        String sessionID = (String)data.get("session_id");
        switch (event) {
            case "reply": {
                String replyText = (String)data.get("text");
                String isEndStr = (String)data.get("is_end");
                Boolean isEnd = Boolean.parseBoolean(isEndStr);
                ReplyFromCallee replyFromCallee = new ReplyFromCallee();
                replyFromCallee.setText(replyText);
                replyFromCallee.setIsEnd(isEnd);
                this.sdk.onReceivingReplyFromCallee(replyFromCallee);
                break;
            }
            case "create": {
                String accountKey = (String)data.get("account_key");
                this.sdk.createCalleeSession(sessionID, accountKey);
                CreatingSessionOfCallee sessionWrapper = new CreatingSessionOfCallee();
                sessionWrapper.setAccountKey(accountKey);
                this.sdk.onCreatingSessionOfCallee(sessionWrapper);
                break;
            }
            case "exit": {
                CalleeSession session = this.sdk.getCalleeSessionBySessionID(sessionID);
                String accountKey = session.getAccountKey();
                this.sdk.removeCalleeSession(sessionID, accountKey);
                CreatingSessionOfCallee sessionWrapper = new CreatingSessionOfCallee();
                sessionWrapper.setAccountKey(accountKey);
                this.sdk.onCreatingSessionOfCallee(sessionWrapper);
                break;
            }
            default: {
                this.mdpClient.sendError("This event is not supported");
            }
        }
    }

    @Override
    public Map processRPCRequest(String event, Map data) {
        String sessionID = (String)data.get("session_id");
        Map ret = new HashMap();
        switch (event) {
            case "knock": {
                KnockFromCaller knock = JsonUtil.mapToObj(data, KnockFromCaller.class);
                KnockResultToCaller result = this.sdk.handleKnockFromCaller(knock);
                ret = JsonUtil.objToMap(result);
                break;
            }
            case "utterance": {
                String text = (String)data.get("text");
                CalleeSession calleeSession = this.sdk.getCalleeSessionBySessionID(sessionID);
                UtteranceFromCaller utterance = new UtteranceFromCaller(calleeSession, text);
                ReplyToCaller reply = this.sdk.onReceivingUtteranceFromCaller(utterance);
                if (null == reply) break;
                ret = JsonUtil.objToMap(reply);
                break;
            }
            default: {
                this.mdpClient.sendError("This event is not supported");
            }
        }
        return ret;
    }
}

