/*
 * Decompiled with CFR 0.152.
 */
package ai.mrs.mdp;

import ai.mrs.mdp.MDPHandler;
import ai.mrs.mdp.MDPProtocol;
import ai.mrs.mdp.RPCWaiter;
import ai.mrs.mdp.WebSocketEndpoint;
import ai.mrs.utils.JsonUtil;
import java.net.Proxy;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.NotYetConnectedException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.java_websocket.WebSocket;
import org.java_websocket.drafts.Draft;
import org.java_websocket.drafts.Draft_6455;

public class MDPClient
implements MDPProtocol {
    private boolean connected = false;
    private MDPHandler handler;
    private Map<String, RPCWaiter> rpcWaiters = new HashMap<String, RPCWaiter>();
    private long rpcTimeout;
    private int connectTimeout;
    private URI uri;
    private Timer reconnectController = null;
    private ConcurrentLinkedQueue<String> messageQueue = new ConcurrentLinkedQueue();
    private Map<String, String> httpHeaders;
    private WebSocketEndpoint ws = null;
    private Proxy proxy = null;

    public MDPClient(String uriStr, MDPHandler handler, Map<String, String> httpHeaders, int connectTimeout, long rpcTimeout, Proxy proxy) {
        try {
            this.uri = new URI(uriStr);
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        this.handler = handler;
        this.httpHeaders = httpHeaders;
        this.rpcTimeout = rpcTimeout;
        this.connectTimeout = connectTimeout;
        this.proxy = proxy;
    }

    @Override
    public void sendMessage(Map<String, Object> msg) {
        String msgID = this.generateUniID();
        msg.put("msg_id", msgID);
        this.send(JsonUtil.mapToJson(msg));
    }

    @Override
    public void sendEvent(String event, Map data) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("event", event);
        map.put("data", data);
        this.sendMessage(map);
    }

    @Override
    public Map callRPC(String event, Map data) {
        HashMap<String, Object> msg = new HashMap<String, Object>();
        String rpcID = this.generateUniID();
        msg.put("rpc_id", rpcID);
        msg.put("event", event);
        msg.put("data", data);
        this.sendMessage(msg);
        return this.waitForRpcResponse(rpcID);
    }

    @Override
    public void sendError(String err) {
        HashMap<String, String> obj = new HashMap<String, String>();
        obj.put("error", err);
        this.send(((Object)obj).toString());
    }

    @Override
    public void connect() {
        if (null != this.ws) {
            if (this.webSocketIsOpen() || this.webSocketIsConnecting()) {
                return;
            }
            this.ws.close();
            this.ws = null;
        }
        this.ws = new WebSocketEndpoint(this.uri, (Draft)new Draft_6455(), this.httpHeaders, this.connectTimeout, this, this.proxy);
        this.ws.connect();
    }

    @Override
    public void close() {
        this.reconnectController.cancel();
        this.messageQueue.clear();
        this.ws.close();
    }

    @Override
    public void onOpen() {
        this.connected = true;
        this.reconnectController.cancel();
        if (this.messageQueue.size() > 0) {
            Iterator<String> iter = this.messageQueue.iterator();
            while (iter.hasNext()) {
                this.send(iter.next());
            }
            this.messageQueue.clear();
        }
    }

    @Override
    public void onClose(int code, String reason, boolean remote) {
        this.reconnect();
    }

    @Override
    public void onError(Exception ex) {
    }

    @Override
    public void onMessage(String message) {
        if (message.equals("ping")) {
            this.send("pong");
            return;
        }
        if (message.equals("pong")) {
            return;
        }
        try {
            Map jsonObject = JsonUtil.jsonToMap(message);
            if (jsonObject.containsKey("error")) {
                return;
            }
            if (jsonObject.containsKey("ack")) {
                String msgID = (String)jsonObject.get("ack");
                return;
            }
            if (!jsonObject.containsKey("msg_id")) {
                this.sendError("'msg_id' is missing");
                return;
            }
            String msgID = (String)jsonObject.get("msg_id");
            this.replyAck(msgID);
            if (jsonObject.containsKey("rpc_id")) {
                String rpcID = (String)jsonObject.get("rpc_id");
                if (jsonObject.containsKey("echo")) {
                    Map data = (Map)jsonObject.get("echo");
                    this.processRpcResponse(rpcID, data);
                } else {
                    String event = (String)jsonObject.get("event");
                    Map data = (Map)jsonObject.get("data");
                    this.processRpcRequest(rpcID, event, data);
                }
                return;
            }
            if (jsonObject.containsKey("event")) {
                String event = (String)jsonObject.get("event");
                Map data = (Map)jsonObject.get("data");
                this.processEventMessage(event, data);
            } else {
                this.sendError("'event' is missing");
            }
        }
        catch (Exception e) {
            this.sendError("Not valid JSON format");
        }
    }

    private void replyAck(String msgID) {
        HashMap<String, String> ack = new HashMap<String, String>();
        ack.put("ack", msgID);
        this.send(JsonUtil.mapToJson(ack));
    }

    public void send(String msg) {
        try {
            if (null == this.ws) {
                throw new NotYetConnectedException();
            }
            this.ws.send(msg);
        }
        catch (NotYetConnectedException e) {
            this.reconnect();
            this.messageQueue.add(msg);
        }
    }

    private void reconnect() {
        if (null != this.ws) {
            this.ws.close();
            this.ws = null;
        }
        this.connected = false;
        if (null != this.reconnectController) {
            this.reconnectController.cancel();
        }
        this.reconnectController = new Timer();
        this.reconnectController.schedule(new TimerTask(){

            @Override
            public void run() {
                MDPClient.this.doReconnect();
            }
        }, 0L, 2000L);
    }

    private synchronized void doReconnect() {
        if (this.connected) {
            this.reconnectController.cancel();
            return;
        }
        this.connect();
    }

    private boolean webSocketIsOpen() {
        return this.ws.getReadyState() == WebSocket.READYSTATE.OPEN;
    }

    private boolean webSocketIsConnecting() {
        return this.ws.getReadyState() == WebSocket.READYSTATE.CONNECTING;
    }

    private Map waitForRpcResponse(String rpcID) {
        RPCWaiter waiter = new RPCWaiter(this.rpcTimeout);
        this.rpcWaiters.put(rpcID, waiter);
        waiter.acquire();
        Map result = waiter.getResult();
        this.rpcWaiters.remove(rpcID);
        return result;
    }

    private void processRpcRequest(String rpcID, String event, Map req) {
        Map respData = this.handler.processRPCRequest(event, req);
        HashMap<String, Object> resp = new HashMap<String, Object>();
        resp.put("rpc_id", rpcID);
        resp.put("event", event);
        resp.put("data", respData);
        this.sendMessage(resp);
    }

    private void processRpcResponse(String rpcID, Map data) {
        RPCWaiter waiter = this.rpcWaiters.get(rpcID);
        if (null != waiter) {
            waiter.setResult(data);
            waiter.release();
        }
    }

    private void processEventMessage(String event, Map data) {
        this.handler.processEventMessage(event, data);
    }

    private String generateUniID() {
        return UUID.randomUUID().toString();
    }
}

