package ai.mrs;

import java.net.Proxy;
import java.util.Arrays;
import java.util.Base64;
import java.util.Map;

public class MasonsSDKConfig {
    private String wsUrl = "ws://svc.masons.mrs.ai/api/v1/masons";
    private String nodeUrl = "https://svc.masons.mrs.ai/api/v1/masons/nodes";
    private String agentToken;
    private Boolean debug = false;
    private long rpcTimeout = 1000L;
    private int connectTimeout = 1000;
    private Map<String, String> connectHeaders = null;
    private Proxy proxy = null;
    private String proxyAuthorization = null;

    public MasonsSDKConfig(String agentToken) {
        this.agentToken = agentToken;
    }

    public MasonsSDKConfig(String agentToken, String wsUrl, String nodeUrl) {
        this.agentToken = agentToken;
        this.wsUrl = wsUrl;
        this.nodeUrl = nodeUrl;
    }

    public MasonsSDKConfig(String agentToken, String wsUrl, String nodeUrl,
                           long rpcTimeout, int connectTimeout) {
        this.agentToken = agentToken;
        this.wsUrl = wsUrl;
        this.nodeUrl = nodeUrl;
        this.rpcTimeout = rpcTimeout;
        this.connectTimeout = connectTimeout;
    }

    public String getWsUrl() {
        return this.wsUrl;
    }

    public String getNodeUrl() {
        return this.nodeUrl;
    }

    public String getAgentToken() {
        return this.agentToken;
    }

    public long getRpcTimeout() {
        return rpcTimeout;
    }

    public int getConnectTimeout() {
        return connectTimeout;
    }

    public void setWsUrl(String wsUrl) {
        this.wsUrl = wsUrl;
    }

    public void setNodeUrl(String nodeUrl) {
        this.nodeUrl = nodeUrl;
    }

    public void setAgentToken(String agentToken) {
        this.agentToken = agentToken;
    }

    public void setRpcTimeout(long rpcTimeout) {
        this.rpcTimeout = rpcTimeout;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public Boolean getDebug() {
        return debug;
    }

    public void setDebug(Boolean debug) {
        this.debug = debug;
    }

    public Proxy getProxy() {
        return proxy;
    }

    public void setProxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public Map<String, String> getConnectHeaders() {
        return connectHeaders;
    }

    public void setConnectHeaders(Map<String, String> connectHeaders) {
        this.connectHeaders = connectHeaders;
    }

    public String getProxyAuthorization() {
        return proxyAuthorization;
    }

    public void setProxyAuthorization(String username, String password) {
        Base64.Encoder encoder = Base64.getEncoder();
        String encryptAuth = encoder.encodeToString((username + ":" + password).getBytes());
        this.proxyAuthorization = "Basic " + encryptAuth.substring(0, 12);
    }
}
