package ai.mrs.cli;

import ai.mrs.AbstractMasonsSDK;
import ai.mrs.session.CalleeSession;
import ai.mrs.session.CallerSession;
import ai.mrs.session.models.*;
import ai.mrs.utils.JsonUtil;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.UUID;

public class Debugger {
    private AbstractMasonsSDK sdkRef;
    private String sessionIdRef;

    public Debugger(AbstractMasonsSDK sdkRef) {
        this.sdkRef = sdkRef;
    }

    public void run() {
        System.out.println("[Debug] Start");
        try {
            BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
            String line;

            System.out.println("Commands:\n" +
                    "  exit\n" +
                    "  knock <Text>\n" +
                    "  send <Text>\n" +
                    "  reply <Text>\n" +
                    "");
            boolean flag = true;
            while (flag) {
                line = reader.readLine().trim();
                String[] argv = line.split(" ", 2);
                String cmd = argv[0];

                if (cmd.isEmpty()) {
                    continue;
                }

                switch (cmd) {
                    case "knock": {
                        String text = argv[1];
                        String accountKey = "";
                        KnockFromCaller knock = new KnockFromCaller();
                        knock.setAccountKey(accountKey);
                        knock.setText(text);
                        KnockResultToCaller result = sdkRef.handleKnockFromCaller(knock);
                        if (null == result) {
                            System.out.println("[Debug] " + "Knock Response: " + "null");
                        } else {
                            System.out.println("[Debug] " + "Knock Response: " + JsonUtil.objToJson(result));
                            if (result.getSuccess()) {
                                createCalleeSession(text);
                            }
                        }
                        break;
                    }
                    case "send": {
                        String text = argv[1];
                        CalleeSession session = sdkRef.getCalleeSessionBySessionID(sessionIdRef);
                        UtteranceFromCaller utterance = new UtteranceFromCaller(session, text);
                        ReplyToCaller reply = sdkRef.onReceivingUtteranceFromCaller(utterance);
                        if (null != reply && null != reply.getText() && !reply.getText().isEmpty()) {
                            System.out.println("[Reply] " + reply.getText());
                            if (reply.getIsEnd()) {
                                System.out.println("[Debug] " + "Session ended, " + sessionIdRef);
                            }
                        } else {
                            System.out.println("[Reply] " + "null");
                        }
                        break;
                    }
                    case "reply": {
                        String text = argv[1];
                        CalleeSession session = sdkRef.getCalleeSessionBySessionID(sessionIdRef);
                        if (null == session) {
                            createCalleeSession(text);
                            session = sdkRef.getCalleeSessionBySessionID(sessionIdRef);
                        }
                        UtteranceFromCaller utterance = new UtteranceFromCaller(session, text);
                        ReplyToCaller reply = sdkRef.onReceivingUtteranceFromCaller(utterance);
                        if (null != reply) {
                            System.out.println("[Reply] " + reply.getText());
                        } else {
                            System.out.println("[Reply] " + "null");
                        }
                        break;
                    }
                    case "end": {
                        String text;
                        if (argv.length > 1) {
                            text = argv[1];
                        } else {
                            text = null;
                        }

                        CallerSession callerSession = sdkRef.getCallerSessionBySessionID(sessionIdRef);
                        if (null != callerSession) {
                            System.out.println("[Debug] " + "Session ended, " + sessionIdRef);
                        }

                        CalleeSession calleeSession = sdkRef.getCalleeSessionBySessionID(sessionIdRef);
                        if (null != calleeSession) {
                            calleeSession.exit(text);
                            System.out.println("[Debug] " + "Session ended, " + sessionIdRef);
                        }

                        sessionIdRef = null;
                        break;
                    }
                    case "exit": {
                        sdkRef.stop();
                        flag = false;
                        break;
                    }
                    default: {
                        System.out.println("[Debug] " + "Wrong command");
                    }
                }
            }
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void createCalleeSession(String text) {
        sessionIdRef = UUID.randomUUID().toString();
        System.out.println("[Debug] " + "Session ID: " + sessionIdRef);
        CreatingSessionOfCallee creatingSessionOfCallee = new CreatingSessionOfCallee();
        String accountKeyRef = "tester";
        creatingSessionOfCallee.setAccountKey(accountKeyRef);
        creatingSessionOfCallee.setText(text);
        sdkRef.onCreatingSessionOfCallee(creatingSessionOfCallee);
    }
}
