package ai.mrs.mdp;


import java.util.Map;

public interface MDPProtocol {
    void sendMessage(Map<String, Object> msg);

    void sendEvent(String event, Map data);

    Map callRPC(String event, Map data);

    void sendError(String err);

    void connect();

    void close();

    void onOpen();

    void onError(Exception e);

    void onClose(int code, String reason, boolean remote);

    void onMessage(String message);
}
