/*
 * Decompiled with CFR 0.152.
 */
package ai.mykg.mytool.convert;

import ai.mykg.mytool.convert.ConvertException;
import java.io.Serializable;
import java.util.HashSet;

public class BaseConverter
implements Serializable {
    private static final long serialVersionUID = -343663115496966264L;
    public static final String BIN = "01";
    public static final String OCT = "01234567";
    public static final String DEC = "0123456789";
    public static final String HEX = "0123456789abcdef";
    public static final String BASE58 = "123456789abcdefghijkmnopqrstuvwxyzABCDEFGHJKLMNPQRSTUVWXYZ";
    private final String srcAlphabet;
    private final String distAlphabet;
    private final Boolean isSameAlphabet;

    public BaseConverter(String srcAlphabet, String distAlphabet) throws ConvertException {
        this.checkAlphabet(srcAlphabet);
        this.checkAlphabet(distAlphabet);
        this.srcAlphabet = srcAlphabet;
        this.distAlphabet = distAlphabet;
        this.isSameAlphabet = srcAlphabet.equals(distAlphabet);
    }

    public String convert(String str) {
        if (this.isSameAlphabet.booleanValue()) {
            return str;
        }
        return BaseConverter.convert(this.srcAlphabet, this.distAlphabet, str);
    }

    public String revert(String str) {
        if (this.isSameAlphabet.booleanValue()) {
            return str;
        }
        return BaseConverter.convert(this.distAlphabet, this.srcAlphabet, str);
    }

    private static String convert(String srcAlphabet, String distAlphabet, String str) {
        int newLen;
        int fromBase = srcAlphabet.length();
        int toBase = distAlphabet.length();
        int len = str.length();
        Integer[] numArray = new Integer[str.length()];
        for (int i = 0; i < len; ++i) {
            numArray[i] = srcAlphabet.indexOf(str.charAt(i));
        }
        String result = "";
        do {
            int divide = 0;
            newLen = 0;
            for (int i = 0; i < len; ++i) {
                if ((divide = divide * fromBase + numArray[i]) >= toBase) {
                    numArray[newLen] = divide / toBase;
                    ++newLen;
                    divide %= toBase;
                    continue;
                }
                if (newLen <= 0) continue;
                numArray[newLen] = 0;
                ++newLen;
            }
            len = newLen;
            result = distAlphabet.substring(divide, divide + 1).concat(result);
        } while (newLen != 0);
        return result;
    }

    private void checkAlphabet(String alphabet) throws ConvertException {
        int strLen;
        if (alphabet == null || (strLen = alphabet.length()) == 0) {
            throw new ConvertException("Empty alphabet!");
        }
        HashSet<Character> chars = new HashSet<Character>();
        for (int i = 0; i < strLen; ++i) {
            Character c = Character.valueOf(alphabet.charAt(i));
            if (Character.isWhitespace(c.charValue()) || chars.contains(c)) {
                throw new ConvertException("Bad alphabet!");
            }
            chars.add(c);
        }
    }
}

