package ai.nextbillion.gradle

import ai.nextbillion.nexbillionmaven.UploadInfo
import ai.nextbillion.nexbillionmaven.UploadInfoParser
import org.gradle.api.artifacts.dsl.DependencyHandler
import org.gradle.api.tasks.Exec
import ai.nextbillion.nexbillionmaven.FileUtils
import org.gradle.api.Plugin
import org.gradle.api.Project
import org.gradle.api.artifacts.dsl.RepositoryHandler

import org.gradle.util.GradleVersion

import ai.nextbillion.gradle.extensions.Publish

/**
 * Support for gcp maven and maven2 project packaging upload
 */
class MavenUploadPlugin implements Plugin<Project> {

    public static final String UPLOAD_EXTENSION_NAME = "upload"
    private boolean isRelease = false;

    @Override
    void apply(Project project) {

        isRelease = false
        File file = project.file('build.gradle')
        UploadInfo publish = UploadInfoParser.getPublish(file.text)
        if (publish == null) {
            return
        }
        println('-----upload info-----')
        println(publish.toString())
        isRelease = publish.release;
        configProject(project, publish)
        applyDependencies(project)
        applyConfiguration(project)
        applyExtension(project)
    }

    /**
     * set submodule configuration parameter
     * @param project
     * @param rootConfig
     */
    private void configProject(Project project,UploadInfo rootConfig) {

        project.extensions.extraProperties.set("nextBillionArtifactGroupId", rootConfig.groupId)
        project.extensions.extraProperties.set("nextBillionArtifactId", rootConfig.artifactId)

        project.extensions.extraProperties.set("nextBillionArtifactTitle", rootConfig.sdkName)
        project.extensions.extraProperties.set("nextBillionArtifactDescription", rootConfig.sdkDescription)
        project.extensions.extraProperties.set("nextBillionDeveloperName",'Nextbillion AI Mobile')
        project.extensions.extraProperties.set("nextBillionDeveloperId", 'NB Mobile')
        project.extensions.extraProperties.set("nextBillionArtifactUrl",'https://' + rootConfig.codeReportUrl)

        project.extensions.extraProperties.set("nextBillionArtifactScmUrl", 'scm:' + rootConfig.codeReportUrl)
        project.extensions.extraProperties.set("nextBillionArtifactLicenseName", 'BSD')
        project.extensions.extraProperties.set("nextBillionArtifactLicenseUrl", 'https://opensource.org/licenses/BSD-2-Clause')
        project.extensions.extraProperties.set("versionName", rootConfig.version)
        project.extensions.extraProperties.set("USE_RELEASE_MAVEN",rootConfig.release)
        // maven2
        project.extensions.extraProperties.set("username",rootConfig.userName)
        project.extensions.extraProperties.set("username",rootConfig.password)
        project.extensions.extraProperties.set("username",rootConfig.email)
    }

    private void applyDependencies(Project project) {
        DependencyHandler dependencyHandler = project.getBuildscript().getDependencies()
        dependencyHandler.add("classpath","gradle.plugin.com.google.cloud.artifactregistry:artifactregistry-gradle-plugin:2.1.1")

        // project maven repositories
        def currentGradleVersion = GradleVersion.version(project.gradle.gradleVersion)
        def v7GradleVersion = GradleVersion.version("7.0")
        if (currentGradleVersion.compareTo(v7GradleVersion) > 0) {
            project.gradle.settingsEvaluated {
                RepositoryHandler repositories = settings
                        .dependencyResolutionManagement
                        .repositories

                repositories.maven {
                    url "artifactregistry://asia-maven.pkg.dev/nextbillion/mobile-snapshot-maven"
                }
                repositories.maven {
                    url 'https://repo.gradle.org/gradle/libs-releases'
                }
            }
        } else {
            project.allprojects {
                repositories {
                    mavenCentral()
                    maven { url 'https://repo.gradle.org/gradle/libs-releases' }
                    maven {
                        url "artifactregistry://asia-maven.pkg.dev/nextbillion/mobile-snapshot-maven"
                    }
                    maven {
                        url 'https://repo.gradle.org/gradle/libs-releases'
                    }
                }
                dependencies {

                }
            }

        }


        // buildScript
        project.buildscript.repositories {
            mavenCentral()
            google()
            maven { url 'https://plugins.gradle.org/m2' }
            maven { url 'https://repo.gradle.org/gradle/libs-releases' }
        }

        // class dependencies
        project.buildscript {
            dependencies {
                classpath "gradle.plugin.com.google.cloud.artifactregistry:artifactregistry-gradle-plugin:2.1.1"
            }
        }
//        project.buildscript.dependencies.add('classpath','digital.wup:android-maven-publish:3.6.2')

        project.buildscript.dependencies.add('classpath','gradle.plugin.com.google.cloud.artifactregistry:artifactregistry-gradle-plugin:2.1.1')
    }


    private void applyExtension(Project project) {
        project.extensions.create(UPLOAD_EXTENSION_NAME, Publish)
    }

    private void applyConfiguration(Project project) {

        copyGradleToProject(project)

        // register task
        def cmd = project.rootProject.rootDir.absolutePath + "/gradlew"
        project.tasks.register("NBGCPMaven", Exec) {
            def stdout = new ByteArrayOutputStream()
            commandLine cmd, "publishNBGCPMavenPublicationToMavenRepository"
            workingDir project.projectDir
            standardOutput stdout
        }

        project.tasks.register("NBMaven2", Exec) {
            def stdout = new ByteArrayOutputStream()
            commandLine cmd, "publishNBMaven2PublicationToMavenRepository"
            workingDir project.projectDir
            standardOutput stdout
        }

    }

    /**
     * copy gradle files to apply project and apply gradle script
     * @param project
     */
    private void copyGradleToProject(Project project) {

        //gcp-maven-publish.gradle
        def gcpMavenPublishFile = getClass().getResourceAsStream("/gcp-maven-publish.gradle")
        FileUtils.saveFileToFolder(project.rootProject.file('build'),'gcp-maven-publish.gradle',gcpMavenPublishFile.text)
        gcpMavenPublishFile.close()

        //publish-sdk.gradle
        def publishSdkFile = getClass().getResourceAsStream("/publish-sdk.gradle")
        FileUtils.saveFileToFolder(project.rootProject.file('build'),'publish-sdk.gradle',publishSdkFile.text)
        publishSdkFile.close()

        // apply script
        def propertiesFile = project.rootProject.file('gradle.properties')
        project.apply(plugin: 'com.google.cloud.artifactregistry.gradle-plugin')
        def useReleaseMaven = null
        def version = null
        if (propertiesFile.exists()) {
            def properties = new Properties()
            properties.load(propertiesFile.newDataInputStream())
            useReleaseMaven = properties.getProperty('USE_RELEASE_MAVEN')
            version = properties.getProperty("VERSION")
        }
        // check release
        if (useReleaseMaven == null) {
            print('Global release switch:' + isRelease)
            if (isRelease) {
                project.apply(from: project.rootProject.file('build').absolutePath + '/publish-sdk.gradle')
            } else {
                project.apply(from: project.rootProject.file('build').absolutePath + '/gcp-maven-publish.gradle')
            }
            return
        }

        // check version
        if (version != null) {
            print('Global version:' + version)
            project.extensions.extraProperties.set("versionName", version)
        }

        if (Boolean.valueOf(useReleaseMaven)) {
            project.apply(from: project.rootProject.file('build').absolutePath + '/publish-sdk.gradle')
        } else {
            project.apply(from: project.rootProject.file('build').absolutePath + '/gcp-maven-publish.gradle')
        }



//        project.subprojects {
//            apply plugin: 'com.google.cloud.artifactregistry.gradle-plugin'
//        }

//        project.subprojects.each {
//            it.apply(from: project.rootDir.absolutePath + '/gradle/publish.gradle')
//        }

    }

}