package ai.nextbillion.nexbillionmaven;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;

public class FileUtils {


    public static void saveFileToFolder(File folderFile, String fileName, String fileContentData) {

        if (folderFile != null && !folderFile.exists()) {
            folderFile.mkdirs();
        }

        File createFile = new File(folderFile, fileName);

        if (createFile.exists()) {
            boolean delete = createFile.delete();
        }

        try {
            boolean create = createFile.createNewFile();
        } catch (IOException e) {
            e.printStackTrace();
        }

        if (createFile.exists()) {
            FileOutputStream outputStream = null;
            OutputStreamWriter outputStreamWriter = null;
            BufferedWriter writer = null;
            try {
                outputStream = new FileOutputStream(createFile);
                outputStreamWriter = new OutputStreamWriter(outputStream);
                writer = new BufferedWriter(outputStreamWriter);
                writer.write(fileContentData);
            } catch (IOException e) {
                e.printStackTrace();
            } finally {
                try {
                    if (writer != null) {
                        writer.close();
                    }
                    if (outputStreamWriter != null) {
                        outputStream.close();
                    }
                    if (outputStream != null) {
                        outputStream.close();
                    }
                } catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}
