package ai.nextbillion.nexbillionmaven;

public class UploadInfoParser {

    public static UploadInfo getPublish(String buildContent) {
        if (!buildContent.contains("upload {") && !buildContent.contains("upload{")) {
            return null;
        }
        int startIndex = buildContent.indexOf("upload{");
        if (startIndex == -1) {
            startIndex = buildContent.indexOf("upload {");
        }
        if (startIndex == -1) {
            return null;
        }
        String upload = buildContent.substring(startIndex, buildContent.indexOf("}",startIndex));
        UploadInfo publish = new UploadInfo();

        String[] lines = upload.split("\n");
        for (String line : lines) {
            if (line.trim().isEmpty()) {
                continue;
            }

            String[] parts = line.trim().split("=");
            if (parts.length != 2) {
                continue;
            }

            String key = parts[0].trim();
            String value = parts[1].trim().replaceAll("\"|'", "");
            switch (key) {
                case "groupId":
                    publish.setGroupId(value);
                    break;
                case "artifactId":
                    publish.setArtifactId(value);
                    break;
                case "version":
                    publish.setVersion(value);
                    break;
                case "codeReportUrl":
                    publish.setCodeReportUrl(value);
                    break;
                case "sdkName":
                    publish.setSdkName(value);
                    break;
                case "sdkDescription":
                    publish.setSdkDescription(value);
                    break;
                case "userName":
                    publish.setUserName(value);
                    break;
                case "password":
                    publish.setPassword(value);
                    break;
                case "email":
                    publish.setEmail(value);
                case "release":
                    publish.setRelease(Boolean.getBoolean(value));
                    break;
                default:
                    throw new IllegalArgumentException("Invalid key: " + key);
            }
        }
        return publish;
    }
}
