package ai.nextbillion.api;


import java.io.IOException;
import java.util.List;


import ai.nextbillion.api.directions.NBDirections;
import ai.nextbillion.api.directions.NBDirectionsResponse;
import ai.nextbillion.api.distancematrix.NBDistanceMatrix;
import ai.nextbillion.api.distancematrix.NBDistanceMatrixResponse;
import ai.nextbillion.api.models.NBLocation;
import ai.nextbillion.api.snaptoroad.NBSnapToRoad;
import ai.nextbillion.api.snaptoroad.NBSnapToRoadResponse;
import retrofit2.Callback;
import retrofit2.Response;

public class NBMapAPI {
    private String key;
    private String mode;
    private String baseUrl;
    private String routingService = "directions";
    private boolean debug = false;
    private String avoid;
    private String overview = "full";
    private String approaches;
    private String truckSize;
    private int truckWeight;


    private static class BillPughSingleton {
        private static final NBMapAPI INSTANCE = new NBMapAPI();
    }

    public static NBMapAPI getInstance() {
        return BillPughSingleton.INSTANCE;
    }

    public static NBMapAPI getInstance(String key, String baseUrl) {
        NBMapAPI instance = BillPughSingleton.INSTANCE;
        instance.setKey(key);
        instance.setBaseUrl(baseUrl);
        instance.setOverview("full");
        instance.setApproaches("");
        instance.setTruckWeight(0);
        instance.setTruckSize("");
        instance.setAvoid("");
        return instance;
    }

    public static NBMapAPI getDebugInstance() {
        NBMapAPI instance = BillPughSingleton.INSTANCE;
        instance.setKey("plaintesting");
        instance.setMode("4w");
        instance.setBaseUrl("https://api.nextbillion.io");
        instance.setOverview("full");
        instance.setApproaches("");
        instance.setTruckWeight(0);
        instance.setTruckSize("");
        instance.setAvoid("");
        return instance;
    }

    private NBMapAPI() {
    }

    public String getKey() {
        return key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public String getMode() {
        return mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public String getBaseUrl() {
        return baseUrl;
    }

    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    public boolean isDebug() {
        return debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setRoutingService(String service) {
        this.routingService = service;
    }

    public void setOverview(String overview) {
        this.overview = overview;
    }

    public String getOverview() {
       return overview;
    }

    public void setApproaches(String approaches) {
        this.approaches = approaches;
    }

    public String getApproaches() {
        return approaches;
    }


    public void setTruckSize(String truckSize) {
        this.truckSize = truckSize;
    }

    public String getTruckSize() {
        return truckSize;
    }

    public void setTruckWeight(int truckWeight) {
        this.truckWeight = truckWeight;
    }

    public int getTruckWeight() {
        return truckWeight;
    }

    public void setAvoid(String avoid) {
        this.avoid = avoid;
    }

    public String getAvoid() {
        return avoid;
    }
    ///////////////////////////////////////////////////////////////////////////
    // Directions
    ///////////////////////////////////////////////////////////////////////////

    public Response<NBDirectionsResponse> getDirections(NBLocation origin, NBLocation destination) throws IOException {

        NBDirections nbDirections = getDirectionsBuilder()
                .origin(origin)
                .destination(destination)
                .steps(true)
                .build();
        nbDirections.enableDebug(debug);
        return nbDirections.executeCall();
    }

    public void enqueueGetDirections(NBLocation origin, NBLocation destination, Callback<NBDirectionsResponse> callback) {
        NBDirections nbDirections = getDirectionsBuilder()
                .origin(origin)
                .destination(destination)
                .steps(true)
                .build();
        nbDirections.enableDebug(debug);
        nbDirections.enqueueCall(callback);
    }

    public NBDirections.Builder getDirectionsBuilder() {
        int departureTime = (int) System.currentTimeMillis() / 1000;
        return NBDirections.builder()
                .service(routingService)
                .alternativeCount(1)
                .alternatives(true)
                .departureTime(departureTime)
                .baseUrl(baseUrl)
                .key(key)
                .mode(mode)
                .debug(debug)
                .steps(true)
                .avoid(avoid)
                .overview(overview)
                .approaches(approaches)
                .truckSize(truckSize)
                .truckWeight(truckWeight);
    }

    ///////////////////////////////////////////////////////////////////////////
    // Distance Matrix
    ///////////////////////////////////////////////////////////////////////////

    public Response<NBDistanceMatrixResponse> getDistanceMatrix(List<NBLocation> origins, List<NBLocation> destinations) throws IOException {

        NBDistanceMatrix distanceMatrix = getDistanceMatrixBuilder()
                .origins(origins)
                .destinations(destinations)
                .departureTime((int) System.currentTimeMillis() / 1000)
                .build();
        distanceMatrix.enableDebug(debug);
        return distanceMatrix.executeCall();
    }

    public void enqueueGetDistanceMatrix(List<NBLocation> origins, List<NBLocation> destinations, Callback<NBDistanceMatrixResponse> callback) {
        NBDistanceMatrix distanceMatrix = getDistanceMatrixBuilder()
                .origins(origins)
                .destinations(destinations)
                .departureTime((int) System.currentTimeMillis() / 1000)
                .build();
        distanceMatrix.enableDebug(debug);
        distanceMatrix.enqueueCall(callback);
    }

    public NBDistanceMatrix.Builder getDistanceMatrixBuilder() {
        return NBDistanceMatrix.builder()
                .baseUrl(baseUrl)
                .mode(mode)
                .debug(debug)
                .key(key);
    }

    ///////////////////////////////////////////////////////////////////////////
    // Matching / Snap To Roads
    ///////////////////////////////////////////////////////////////////////////

    public Response<NBSnapToRoadResponse> getSnapToRoad(List<NBLocation> pointsOnPath) throws IOException {
        NBSnapToRoad snapToRoad = getSnapToRoadBuilder()
                .path(pointsOnPath)
                .build();
        snapToRoad.enableDebug(debug);
        return snapToRoad.executeCall();
    }

    public void enqueueGetSnapToRoads(List<NBLocation> pointsOnPath, Callback<NBSnapToRoadResponse> callback) {
        NBSnapToRoad snapToRoad = getSnapToRoadBuilder()
                .path(pointsOnPath)
                .build();
        snapToRoad.enableDebug(debug);
        snapToRoad.enqueueCall(callback);
    }

    public NBSnapToRoad.Builder getSnapToRoadBuilder() {
        return NBSnapToRoad.builder()
                .baseUrl(baseUrl)
                .key(key)
                .interpolate(true)
                .tolerateOutlier(false);
    }
}