package ai.nextbillion.api.directions;

import androidx.annotation.Nullable;

import com.google.auto.value.AutoValue;
import com.google.gson.GsonBuilder;

import ai.nextbillion.kits.core.NBService;
import ai.nextbillion.kits.core.constants.Constants;

import ai.nextbillion.api.models.NBLocation;
import retrofit2.Call;

@AutoValue
public abstract class NBDirections extends NBService<NBDirectionsResponse, NBDirectionsService> {

    public NBDirections() {
        super(NBDirectionsService.class);
    }

    @Override
    protected abstract String baseUrl();

    @Override
    protected Call<NBDirectionsResponse> initializeCall() {
        return get();
    }

    ///////////////////////////////////////////////////////////////////////////
    // HTTP
    ///////////////////////////////////////////////////////////////////////////

    private Call<NBDirectionsResponse> get() {
        String origin = origin() != null ? origin().toString() : null;
        String dest = destination() != null ? destination().toString() : null;
        return getService().getDirections(
                service(),
                alternativeCount(),
                alternatives(),
                debug(),
                departureTime(),
                dest,
                geometry(),
                geometry_type(),
                key(),
                mode(),
                lang(),
                origin,
                session(),
                steps(),
                wayPoints(),
                avoid(),
                overview(),
                approaches(),
                truckSize(),
                truckWeight(),
                bearings()
        );
    }

    ///////////////////////////////////////////////////////////////////////////
    // Params
    ///////////////////////////////////////////////////////////////////////////

    abstract String service();

    abstract int alternativeCount();

    abstract boolean alternatives();

    abstract boolean debug();

    abstract int departureTime();

    @Nullable
    abstract NBLocation destination();

    @Nullable
    abstract String geometry();

    @Nullable
    abstract String geometry_type();

    abstract String key();

    abstract String mode();

    @Nullable
    abstract String lang();

    @Nullable
    abstract NBLocation origin();

    @Nullable
    abstract String session();

    abstract boolean steps();

    @Nullable
    abstract String wayPoints();

    @Nullable
    abstract String avoid();

    @Nullable
    abstract String overview();

    @Nullable
    abstract String approaches();

    @Nullable
    abstract String truckSize();

    abstract int truckWeight();
    
    @Nullable
    abstract String bearings();

    ///////////////////////////////////////////////////////////////////////////
    // Builder
    ///////////////////////////////////////////////////////////////////////////
    @Override
    protected GsonBuilder getGsonBuilder() {
        return super.getGsonBuilder().registerTypeAdapterFactory(NBDirectionAdapterFactory.create());
    }

    public static Builder builder() {
        return new AutoValue_NBDirections.Builder().baseUrl(Constants.BASE_API_URL);
    }

    @AutoValue.Builder
    public abstract static class Builder {
        public abstract Builder baseUrl(String baseUrl);

        public abstract Builder service(String service);

        public abstract Builder alternativeCount(int alternativeCount);

        public abstract Builder alternatives(boolean alternatives);

        public abstract Builder debug(boolean debug);

        public abstract Builder departureTime(int departureTime);

        public abstract Builder destination(NBLocation destination);

        public abstract Builder geometry(String geometry);

        public abstract Builder geometry_type(String geometry_type);

        public abstract Builder key(String key);

        public abstract Builder mode(String mode);

        public abstract Builder lang(String lang);

        public abstract Builder origin(NBLocation origin);

        public abstract Builder session(String session);

        public abstract Builder steps(boolean steps);

        public abstract Builder wayPoints(String wayPoints);

        public abstract Builder avoid(String avoid);

        public abstract Builder overview(String overview);

        public abstract Builder approaches(String approaches);

        public abstract Builder truckSize(String truckSize);

        public abstract Builder truckWeight(int truckWeight);

        public abstract Builder bearings(String bearings);
        
        public abstract NBDirections build();
    }
}
