package ai.nextbillion.api.directions;

import androidx.annotation.Nullable;

import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;

import java.io.Serializable;
import java.util.List;

import ai.nextbillion.api.models.directions.NBRoute;


@AutoValue
public abstract class NBDirectionsResponse implements Serializable {

    ///////////////////////////////////////////////////////////////////////////
    // Params
    ///////////////////////////////////////////////////////////////////////////
    @Nullable
    public abstract String errorMessage();

    @Nullable
    public abstract String mode();

    @Nullable
    public abstract String status();

    public abstract List<NBRoute> routes();

    @Nullable
    public abstract String country_code();

    ///////////////////////////////////////////////////////////////////////////
    // Params end
    ///////////////////////////////////////////////////////////////////////////


    public static Builder builder() {
        return new AutoValue_NBDirectionsResponse.Builder();
    }

    public abstract Builder toBuilder();

    public static TypeAdapter<NBDirectionsResponse> typeAdapter(Gson gson) {
        return new AutoValue_NBDirectionsResponse.GsonTypeAdapter(gson);
    }

    @AutoValue.Builder
    public abstract static class Builder {

        public abstract Builder errorMessage(String errorMessage);

        public abstract Builder mode(String mode);

        public abstract Builder status(String status);

        public abstract Builder routes(List<NBRoute> routes);

        public abstract Builder country_code(String country_code);

        public abstract NBDirectionsResponse build();
    }

}
