package ai.nextbillion.api.directions;

import retrofit2.Call;
import retrofit2.http.GET;
import retrofit2.http.Path;
import retrofit2.http.Query;

public interface NBDirectionsService {
    //context is deprecated
    //special object types is for L&T only
    @GET("/{service}/json")
    Call<NBDirectionsResponse> getDirections(
            @Path("service") String service,
            @Query("altcount") int alternativeCount,
            @Query("alternatives") boolean alternatives,
            @Query("debug") boolean debug,
            @Query("departure_time") int departureTime,
            @Query("destination") String destination,
            @Query("geometry") String geometry,
            @Query("geometry_type") String geometryType,
            @Query("key") String key,
            @Query("mode") String mode,
            @Query("lang") String lang,
            @Query("origin") String origin,
            @Query("session") String session,
            @Query("steps") boolean steps,
            @Query("waypoints") String wayPoints,
            @Query("avoid") String avoid,
            @Query("overview") String overview,
            @Query("approaches") String approaches,
            @Query("truck_size") String truckSize,
            @Query("truck_weight") int truckWeight,
            @Query("bearings") String bearings
    );
}
