package ai.nextbillion.api.distancematrix;

import androidx.annotation.NonNull;

import com.google.auto.value.AutoValue;
import com.google.gson.GsonBuilder;

import ai.nextbillion.kits.core.NBService;
import ai.nextbillion.kits.core.constants.Constants;

import java.util.List;

import ai.nextbillion.api.models.NBLocation;
import ai.nextbillion.api.utils.FormatUtils;
import retrofit2.Call;

@AutoValue
public abstract class NBDistanceMatrix extends NBService<NBDistanceMatrixResponse, NBDistanceMatrixService> {

    public NBDistanceMatrix() {
        super(NBDistanceMatrixService.class);
    }


    @Override
    protected abstract String baseUrl();

    @Override
    protected Call<NBDistanceMatrixResponse> initializeCall() {
        return getService().getDistanceMatrix(
                debug(),
                departureTime(),
                locationsToString(destinations()),
                key(),
                mode(),
                locationsToString(origins())
        );
    }

    ///////////////////////////////////////////////////////////////////////////
    // Params converter
    ///////////////////////////////////////////////////////////////////////////

    private String locationsToString(@NonNull List<NBLocation> locations) {
        return FormatUtils.join("|", locations);
    }

    ///////////////////////////////////////////////////////////////////////////
    // Params
    ///////////////////////////////////////////////////////////////////////////
    abstract boolean debug();

    abstract int departureTime();

    abstract List<NBLocation> destinations();

    abstract String key();

    abstract String mode();

    abstract List<NBLocation> origins();

    ///////////////////////////////////////////////////////////////////////////
    // Builder
    ///////////////////////////////////////////////////////////////////////////

    @Override
    protected GsonBuilder getGsonBuilder() {
        return super.getGsonBuilder().registerTypeAdapterFactory(NBDistanceMatrixAdapterFactory.create());
    }

    public static Builder builder() {
        return new AutoValue_NBDistanceMatrix.Builder().baseUrl(Constants.BASE_API_URL);
    }

    @AutoValue.Builder
    public abstract static class Builder {
        public abstract Builder baseUrl(String baseUrl);

        public abstract Builder debug(boolean debug);

        public abstract Builder departureTime(int departureTime);

        public abstract Builder destinations(List<NBLocation> destinations);

        public abstract Builder key(String accessToken);

        public abstract Builder mode(String mode);

        public abstract Builder origins(List<NBLocation> origins);

        public abstract NBDistanceMatrix build();
    }
}
