package ai.nextbillion.api.distancematrix;

import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;

import java.util.List;

import ai.nextbillion.api.models.NBDistanceMatrixRow;

@AutoValue
public abstract class NBDistanceMatrixResponse {

    ///////////////////////////////////////////////////////////////////////////
    // Params
    ///////////////////////////////////////////////////////////////////////////

    public abstract String status();

    public abstract List<NBDistanceMatrixRow> rows();

    ///////////////////////////////////////////////////////////////////////////
    //  Params end
    ///////////////////////////////////////////////////////////////////////////

    public static TypeAdapter<NBDistanceMatrixResponse> typeAdapter(Gson gson) {
        return new AutoValue_NBDistanceMatrixResponse.GsonTypeAdapter(gson);
    }

    public static Builder builder() {
        return new AutoValue_NBDistanceMatrixResponse.Builder();
    }

    public abstract Builder toBuilder();


    @AutoValue.Builder
    public abstract static class Builder {

        public abstract Builder status(String status);

        public abstract Builder rows(List<NBDistanceMatrixRow> rows);

        public abstract NBDistanceMatrixResponse build();
    }
}
