package ai.nextbillion.api.distancematrix;

import retrofit2.Call;
import retrofit2.http.Field;
import retrofit2.http.FormUrlEncoded;
import retrofit2.http.GET;
import retrofit2.http.POST;
import retrofit2.http.Query;

public interface NBDistanceMatrixService {

    @GET("/distancematrix/json")
    Call<NBDistanceMatrixResponse> getDistanceMatrix(
            @Query("debug") boolean debug,
            @Query("departure_time") int departureTime,
            @Query("destinations") String destinations,
            @Query("key") String accessToken,
            @Query("mode") String mode,
            @Query("origins") String origins

    );

    @FormUrlEncoded
    @POST("/distancematrix/json")
    Call<NBDistanceMatrixResponse> postDistanceMatrix(
            @Field("debug") boolean debug,
            @Field("departure_time") int departureTime,
            @Field("destinations") String destinations,
            @Field("key") String accessToken,
            @Field("mode") String mode,
            @Field("origins") String origins

    );
}
