package ai.nextbillion.api.models;

import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;

@AutoValue
public abstract class NBDistanceMatrixItem {

    public abstract NBDistance distance();

    public abstract NBDuration duration();


    public static TypeAdapter<NBDistanceMatrixItem> typeAdapter(Gson gson) {
        return new AutoValue_NBDistanceMatrixItem.GsonTypeAdapter(gson);
    }

    public static Builder builder() {
        return new AutoValue_NBDistanceMatrixItem.Builder();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public abstract static class Builder {

        public abstract Builder distance(NBDistance distance);

        public abstract Builder duration(NBDuration duration);

        public abstract NBDistanceMatrixItem build();
    }

}
