package ai.nextbillion.api.models.directions;

import androidx.annotation.Nullable;

import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;

import java.util.List;

@AutoValue
public abstract class NBLane {
    public static final String INDICATION_NONE = "none";
    public static final String INDICATION_UTURN = "uturn";
    public static final String INDICATION_SHARP_RIGHT = "sharp right";
    public static final String INDICATION_RIGHT = "right";
    public static final String INDICATION_SLIGHT_RIGHT = "slight right";
    public static final String INDICATION_STRAIGHT = "straight";
    public static final String INDICATION_SLIGHT_LEFT = "slight left";
    public static final String INDICATION_LEFT = "left";
    public static final String INDICATION_SHARP_LEFT = "sharp left";

    @Nullable
    @SerializedName("indications")
    public abstract List<String> indications();

    @SerializedName("valid")
    public abstract boolean valid();

    public static TypeAdapter<NBLane> typeAdapter(Gson gson) {
        return new AutoValue_NBLane.GsonTypeAdapter(gson);
    }

    public static Builder builder() {
        return new AutoValue_NBLane.Builder();
    }

    public abstract Builder toBuilder();


    @AutoValue.Builder
    public abstract static class Builder {

        public abstract Builder indications(List<String> indications);

        public abstract Builder valid(boolean valid);

        public abstract NBLane build();
    }
}
