package ai.nextbillion.api.models.directions;

import androidx.annotation.Nullable;

import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;

import java.util.List;

import ai.nextbillion.api.models.NBDistance;
import ai.nextbillion.api.models.NBDuration;
import ai.nextbillion.api.models.NBLocation;

@AutoValue
public abstract class NBLegStep {

    @Nullable
    @SerializedName("end_location")
    public abstract NBLocation endLocation();

    @Nullable
    @SerializedName("start_location")
    public abstract NBLocation startLocation();

    @Nullable
    @SerializedName("maneuver")
    public abstract NBStepManeuver maneuver();

    @Nullable
    @SerializedName("intersections")
    public abstract List<NBStepIntersection> intersections();

    public abstract NBDistance distance();

    public abstract NBDuration duration();

    @Nullable
    public abstract String geometry();

    @Nullable
    public abstract String name();

    @Nullable
    public abstract String reference();

    @Nullable
    @SerializedName("road_shield_type")
    public  abstract NBRoadShieldType roadShieldType();

    public static TypeAdapter<NBLegStep> typeAdapter(Gson gson) {
        return new AutoValue_NBLegStep.GsonTypeAdapter(gson);
    }

    public static Builder builder() {
        return new AutoValue_NBLegStep.Builder();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public abstract static class Builder {

        public abstract Builder endLocation(NBLocation endLocation);

        public abstract Builder startLocation(NBLocation startLocation);

        public abstract Builder geometry(String geometry);

        public abstract Builder name(String name);

        public abstract Builder reference(String reference);

        public abstract Builder maneuver(NBStepManeuver maneuver);

        public abstract Builder distance(NBDistance distance);

        public abstract Builder duration(NBDuration duration);

        public abstract Builder intersections( List<NBStepIntersection> intersections);

        public abstract Builder roadShieldType(NBRoadShieldType roadShieldType);

        public abstract NBLegStep build();
    }
}
