package ai.nextbillion.api.models.directions;

import androidx.annotation.Nullable;

import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;

@AutoValue
public abstract class NBRoadShieldType {

    @Nullable
    public abstract String label();

    @Nullable
    @SerializedName("image_url")
    public abstract String imageUrl();

    public abstract NBRoadShieldType.Builder toBuilder();


    public static TypeAdapter<NBRoadShieldType> typeAdapter(Gson gson) {
        return new AutoValue_NBRoadShieldType.GsonTypeAdapter(gson);
    }

    public static NBRoadShieldType.Builder builder() {
        return new AutoValue_NBRoadShieldType.Builder();
    }

    @AutoValue.Builder
    public abstract static class Builder {

        public abstract NBRoadShieldType.Builder imageUrl(String imageUrl);

        public abstract NBRoadShieldType.Builder label(String label);

        public abstract NBRoadShieldType build();
    }
}
