package ai.nextbillion.api.models.directions;

import androidx.annotation.Nullable;

import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;

import java.util.List;

import ai.nextbillion.api.models.NBLocation;

@AutoValue
public abstract class NBRoute {

    ///////////////////////////////////////////////////////////////////////////
    // Params
    ///////////////////////////////////////////////////////////////////////////

    public abstract double distance();

    @SerializedName("distance_full")
    public abstract double distanceFull();

    public abstract double duration();

    @Nullable
    @SerializedName("end_location")
    public abstract NBLocation endLocation();

    public abstract String geometry();

    public abstract List<NBRouteLeg> legs();

    @Nullable
    @SerializedName("start_location")
    public abstract NBLocation startLocation();

    ///////////////////////////////////////////////////////////////////////////
    // Params End
    ///////////////////////////////////////////////////////////////////////////

    public static TypeAdapter<NBRoute> typeAdapter(Gson gson) {
        return new AutoValue_NBRoute.GsonTypeAdapter(gson);
    }

    public static Builder builder() {
        return new AutoValue_NBRoute.Builder();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public abstract static class Builder {

        public abstract Builder distance(double distance);

        public abstract Builder distanceFull(double distanceFull);

        public abstract Builder duration(double duration);

        public abstract Builder endLocation(NBLocation endLocation);

        public abstract Builder geometry(String geometry);

        public abstract Builder legs(List<NBRouteLeg> legs);

        public abstract Builder startLocation(NBLocation startLocation);

        public abstract NBRoute build();
    }
}
