package ai.nextbillion.api.models.directions;

import androidx.annotation.Nullable;

import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;

import java.util.List;

import ai.nextbillion.api.models.NBDistance;
import ai.nextbillion.api.models.NBDuration;
import ai.nextbillion.api.models.NBLocation;

@AutoValue
public abstract class NBRouteLeg {

    public abstract NBDistance distance();

    public abstract NBDuration duration();

    @Nullable
    @SerializedName("end_location")
    public abstract NBLocation endLocation();

    @Nullable
    @SerializedName("start_location")
    public abstract NBLocation startLocation();

    @Nullable
    public abstract List<NBLegStep> steps();

    public static TypeAdapter<NBRouteLeg> typeAdapter(Gson gson) {
        return new AutoValue_NBRouteLeg.GsonTypeAdapter(gson);
    }

    public static Builder builder() {
        return new AutoValue_NBRouteLeg.Builder();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public abstract static class Builder {

        public abstract Builder distance(NBDistance distance);

        public abstract Builder duration(NBDuration duration);

        public abstract Builder endLocation(NBLocation endLocation);

        public abstract Builder startLocation(NBLocation startLocation);

        public abstract Builder steps(List<NBLegStep> steps);

        public abstract NBRouteLeg build();
    }

}
