package ai.nextbillion.api.models.directions;

import androidx.annotation.Nullable;

import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;

import java.util.List;

import ai.nextbillion.api.models.NBLocation;

@AutoValue
public abstract class NBStepIntersection {

    @Nullable
    @SerializedName("location")
    public abstract NBLocation location();

    @SerializedName("intersection_in")
    public abstract int in();

    @SerializedName("intersection_out")
    public abstract int out();

    @Nullable
    @SerializedName("bearings")
    public abstract List<Integer> bearings();

    @Nullable
    @SerializedName("entry")
    public abstract List<Boolean> entry();

    @Nullable
    @SerializedName("classes")
    public abstract List<String> classes();

    @Nullable
    @SerializedName("lanes")
    public abstract List<NBLane> lanes();


    public static TypeAdapter<NBStepIntersection> typeAdapter(Gson gson) {
        return new AutoValue_NBStepIntersection.GsonTypeAdapter(gson);
    }

    public static Builder builder() {
        return new AutoValue_NBStepIntersection.Builder();
    }

    public abstract Builder toBuilder();


    @AutoValue.Builder
    public abstract static class Builder {
        public abstract Builder location(NBLocation location);

        public abstract Builder in(int in);

        public abstract Builder out(int out);

        public abstract Builder bearings(List<Integer> bearings);

        public abstract Builder entry(List<Boolean> entry);

        public abstract Builder classes(List<String> classes);

        public abstract Builder lanes(List<NBLane> lanes);

        public abstract NBStepIntersection build();
    }
}
