package ai.nextbillion.api.models.directions;

import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;

import java.util.List;

import ai.nextbillion.api.models.NBLocation;
import androidx.annotation.Nullable;

@AutoValue
public abstract class NBStepManeuver {
    @SerializedName("bearing_after")
    public abstract int bearingAfter();

    @SerializedName("bearing_before")
    public abstract int bearingBefore();

    @SerializedName("coordinate")
    public abstract NBLocation coordinate();

    @SerializedName("maneuver_type")
    public abstract String type();

    @Nullable
    @SerializedName("modifier")
    public abstract String modifier();

    @Nullable
    @SerializedName("instruction")
    public abstract String instruction();

    @Nullable
    @SerializedName("voice_instruction")
    public abstract List<NBVoiceInstruction> voiceInstructions();

    @SerializedName("muted")
    public abstract boolean muted();

    public static TypeAdapter<NBStepManeuver> typeAdapter(Gson gson) {
        return new AutoValue_NBStepManeuver.GsonTypeAdapter(gson);
    }

    public static Builder builder() {
        return new AutoValue_NBStepManeuver.Builder();
    }

    public abstract NBStepManeuver.Builder toBuilder();

    @AutoValue.Builder
    public abstract static class Builder {

        public abstract Builder bearingAfter(int bearingAfter);

        public abstract Builder bearingBefore(int bearingBefore);

        public abstract Builder coordinate(NBLocation coordinate);

        public abstract Builder type(String type);

        public abstract Builder modifier(String modifier);

        public abstract Builder instruction(String instruction);

        public abstract Builder voiceInstructions(List<NBVoiceInstruction> voiceInstructions);

        public abstract Builder muted(boolean muted);

        public abstract NBStepManeuver build();
    }
}
