package ai.nextbillion.api.models.directions;

import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.annotations.SerializedName;

@AutoValue
public abstract class NBVoiceInstruction {

    @SerializedName("distance_along_geometry")
    public abstract double distanceAlongGeometry();

    @SerializedName("unit")
    public abstract String unit();

    @SerializedName("instruction")
    public abstract String instruction();

    public static TypeAdapter<NBVoiceInstruction> typeAdapter(Gson gson) {
        return new AutoValue_NBVoiceInstruction.GsonTypeAdapter(gson);
    }

    public static Builder builder() {
        return new AutoValue_NBVoiceInstruction.Builder();
    }
    public abstract Builder toBuilder();

    @AutoValue.Builder
    public abstract static class Builder {
        public abstract Builder distanceAlongGeometry(double distanceAlongGeometry);

        public abstract Builder unit(String unit);

        public abstract Builder instruction(String instruction);

        public abstract NBVoiceInstruction build();
    }
}
