package ai.nextbillion.api.nearby;

import com.google.auto.value.AutoValue;
import com.google.gson.GsonBuilder;

import ai.nextbillion.kits.core.NBService;
import ai.nextbillion.kits.core.constants.Constants;
import ai.nextbillion.kits.core.exceptions.ServicesException;
import ai.nextbillion.kits.core.utils.NbmapUtils;

import retrofit2.Call;

@AutoValue
public abstract class NBNearBy extends NBService<NBNearByResponse, NBNearByService> {

    public NBNearBy() {
        super(NBNearByService.class);
    }

    @Override
    protected GsonBuilder getGsonBuilder() {
        return super.getGsonBuilder();
    }

    @Override
    protected Call<NBNearByResponse> initializeCall() {
        return null;
    }

    @Override
    protected abstract String baseUrl();

    ////////////////////Query Params///////////////////////////////////////////

    abstract String currentLocation();

    abstract int maxCount();

    abstract int searchRadius();

    abstract String serviceType();

    abstract String accessToken();

    ////////////////////Query Params Ends//////////////////////////////////////

    public static Builder builder() {
        return new AutoValue_NBNearBy.Builder().baseUrl(Constants.BASE_API_URL);
    }

    ///////////////////////////////////////////////////////////////////////////
    //
    ///////////////////////////////////////////////////////////////////////////

    @AutoValue.Builder
    public abstract static class Builder {

        abstract Builder currentLocation(String currentLocation);

        abstract Builder maxCount(int maxCount);

        abstract Builder searchRadius(int radius);

        abstract Builder serviceType(String serviceType);

        abstract Builder accessToken(String token);

        public abstract Builder baseUrl(String baseUrl);

        abstract NBNearBy autoBuild();

        public NBNearBy build() {
            NBNearBy nearBy = autoBuild();
            if (!NbmapUtils.isAccessTokenValid(nearBy.accessToken())) {
                throw new ServicesException("Using Nbmap Services requires setting a valid access token.");
            }
            return nearBy;
        }
    }
}
