package ai.nextbillion.api.nearby;

import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;

import java.io.Serializable;
import java.util.List;

import ai.nextbillion.api.models.NBLocation;
import ai.nextbillion.api.models.NBNearByObject;

@AutoValue
public abstract class NBNearByResponse implements Serializable {


    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_NBNearByResponse.Builder();
    }

    public static TypeAdapter<NBNearByResponse> typeAdapter(Gson gson) {
        return new AutoValue_NBNearByResponse.GsonTypeAdapter(gson);
    }

    public abstract NBLocation currentlocation();

    public abstract int maxcount();

    public abstract String servicetype();

    public abstract int searchradius();

    public abstract String status();

    public abstract String msg();

    public abstract List<NBNearByObject> results();

    ///////////////////////////////////////////////////////////////////////////
    // Builder
    ///////////////////////////////////////////////////////////////////////////
    @AutoValue.Builder
    public abstract static class Builder {
        public abstract Builder currentlocation(NBLocation currentLocation);

        public abstract Builder maxcount(int maxCount);

        public abstract Builder servicetype(String serviceType);

        public abstract Builder searchradius(int searchRadius);

        public abstract Builder status(String status);

        public abstract Builder msg(String msg);

        public abstract Builder results(List<NBNearByObject> results);

        public abstract NBNearByResponse build();
    }
}
