package ai.nextbillion.api.posttriproute;

import com.google.auto.value.AutoValue;
import com.google.gson.GsonBuilder;
import ai.nextbillion.kits.core.NBService;
import ai.nextbillion.kits.core.constants.Constants;

import retrofit2.Call;

@AutoValue
public abstract class NBPostTripRoute extends NBService<NBPostTripRouteResponse, NBPostTripRouteService> {

    public NBPostTripRoute() {
        super(NBPostTripRouteService.class);
    }

    ///////////////////////////////////////////////////////////////////////////
    // Override
    ///////////////////////////////////////////////////////////////////////////

    @Override
    protected GsonBuilder getGsonBuilder() {
        return super.getGsonBuilder();
    }

    @Override
    protected Call<NBPostTripRouteResponse> initializeCall() {
        return null;
    }

    @Override
    protected abstract String baseUrl();

    ///////////////////////////////////////////////////////////////////////////
    // Params
    ///////////////////////////////////////////////////////////////////////////

    abstract boolean debug();

    abstract String accessToken();

    abstract String mode();

    abstract String timestamps();

    abstract boolean tolerateOutlier();

    abstract String wayPoints();

    ///////////////////////////////////////////////////////////////////////////
    // Builder
    ///////////////////////////////////////////////////////////////////////////


    public static Builder builder() {
        return new AutoValue_NBPostTripRoute.Builder().baseUrl(Constants.BASE_API_URL);
    }


    @AutoValue.Builder
    public abstract static class Builder {

        abstract Builder debug(boolean debug);

        abstract Builder accessToken(String accessToken);

        abstract Builder mode(String mode);

        abstract Builder baseUrl(String baseUrl);

        abstract Builder timestamps(String timestamps);

        abstract Builder tolerateOutlier(boolean tolerateOutlier);

        abstract Builder wayPoints(String wayPoints);

        abstract NBPostTripRoute build();

    }


}
