package ai.nextbillion.api.posttriproute;

import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;

import ai.nextbillion.api.models.NBSimpleRoute;

@AutoValue
public abstract class NBPostTripRouteResponse {

    public abstract String errorMessage();

    public abstract String mode();

    public abstract String status();

    public abstract NBSimpleRoute route();

    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_NBPostTripRouteResponse.Builder();
    }

    public static TypeAdapter<NBPostTripRouteResponse> typeAdapter(Gson gson) {
        return new AutoValue_NBPostTripRouteResponse.GsonTypeAdapter(gson);
    }

    @AutoValue.Builder
    public abstract static class Builder {


        public abstract Builder errorMessage(String errorMessage);

        public abstract Builder mode(String mode);

        public abstract Builder status(String status);

        public abstract Builder route(NBSimpleRoute route);

        public abstract NBPostTripRouteResponse build();
    }

}
