package ai.nextbillion.api.snaptoroad;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;

import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import ai.nextbillion.kits.core.NBService;


import java.util.List;

import ai.nextbillion.api.models.NBLocation;
import ai.nextbillion.api.utils.FormatUtils;
import retrofit2.Call;

@AutoValue
public abstract class NBSnapToRoad extends NBService<NBSnapToRoadResponse, NBSnapToRoadService> {

    protected NBSnapToRoad() {
        super(NBSnapToRoadService.class);
    }


    @Override
    protected GsonBuilder getGsonBuilder() {
        return super.getGsonBuilder().registerTypeAdapterFactory(NBSnapToRoadsAdapterFactory.create());
    }

    @Override
    protected Call<NBSnapToRoadResponse> initializeCall() {
        return getService().getSnapToRoads(
                interpolate(),
                key(),
                locationsToString(path()),
                listToString(radiuses()),
                timestamps(),
                tolerateOutlier()
        );
    }

    ///////////////////////////////////////////////////////////////////////////
    // Params converter
    ///////////////////////////////////////////////////////////////////////////

    private String locationsToString(@NonNull List<NBLocation> locations) {
        return FormatUtils.join("|", locations);
    }

    private String listToString(@NonNull List<String> list) {
        return FormatUtils.join("|", list);
    }

    ///////////////////////////////////////////////////////////////////////////
    // Params
    ///////////////////////////////////////////////////////////////////////////

    public abstract boolean interpolate();

    @Override
    public abstract String baseUrl();

    public abstract String key();

    public abstract List<NBLocation> path();

    @Nullable
    public abstract List<String> radiuses();

    @Nullable
    public abstract String timestamps();

    public abstract boolean tolerateOutlier();

    ///////////////////////////////////////////////////////////////////////////
    //
    ///////////////////////////////////////////////////////////////////////////

    public static TypeAdapter<NBSnapToRoad> typeAdapter(Gson gson) {
        return new AutoValue_NBSnapToRoad.GsonTypeAdapter(gson);
    }

    public static Builder builder() {
        return new AutoValue_NBSnapToRoad.Builder();
    }

    public abstract Builder toBuilder();

    @AutoValue.Builder
    public abstract static class Builder {

        public abstract Builder interpolate(boolean interpolate);

        public abstract Builder key(String accessToken);

        public abstract Builder path(List<NBLocation> path);

        public abstract Builder radiuses(List<String> radiuses);

        public abstract Builder timestamps(String timestamps);

        public abstract Builder tolerateOutlier(boolean tolerateOutlier);

        public abstract Builder baseUrl(String baseUrl);

        public abstract NBSnapToRoad build();
    }


}
