package ai.nextbillion.api.snaptoroad;

import com.google.auto.value.AutoValue;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;

import java.util.List;

import ai.nextbillion.api.models.NBSnappedPoint;


@AutoValue
public abstract class NBSnapToRoadResponse {


    public abstract int distance();

    public abstract List<String> geometry();

    public abstract String status();

    public abstract List<NBSnappedPoint> snappedPoints();


    public abstract Builder toBuilder();

    public static Builder builder() {
        return new AutoValue_NBSnapToRoadResponse.Builder();
    }

    public static TypeAdapter<NBSnapToRoadResponse> typeAdapter(Gson gson) {
        return new AutoValue_NBSnapToRoadResponse.GsonTypeAdapter(gson);
    }

    @AutoValue.Builder
    public abstract static class Builder {

        public abstract Builder distance(int distance);

        public abstract Builder geometry(List<String> geometry);

        public abstract Builder status(String status);

        public abstract Builder snappedPoints(List<NBSnappedPoint> snappedPoints);

        public abstract NBSnapToRoadResponse build();
    }
}
