package ai.nextbillion.kits.geojson.shifter;

import ai.nextbillion.kits.geojson.Point;

import java.util.Arrays;
import java.util.List;

/**
 * CoordinateShifterManager keeps track of currently set CoordinateShifter.
 */
public final class CoordinateShifterManager {

  private static final CoordinateShifter DEFAULT = new CoordinateShifter() {
    @Override
    public List<Double> shiftLonLat(double lon, double lat) {
      return Arrays.asList(lon, lat);
    }

    @Override
    public List<Double> shiftLonLatAlt(double lon, double lat, double alt) {
      return Double.isNaN(alt)
              ? Arrays.asList(lon, lat) :
              Arrays.asList(lon, lat, alt);
    }

    @Override
    public List<Double> unshiftPoint(Point point) {
      return point.coordinates();
    }

    @Override
    public List<Double> unshiftPoint(List<Double> coordinates) {
      return coordinates;
    }
  };

  private static volatile CoordinateShifter coordinateShifter = DEFAULT;

  /**
   * Currently set CoordinateShifterManager.
   *
   * @return Currently set CoordinateShifterManager
   */
  public static CoordinateShifter getCoordinateShifter() {
    return coordinateShifter;
  }

  /**
   * Sets CoordinateShifterManager.
   *
   * @param coordinateShifter CoordinateShifterManager to be set
   */
  public static void setCoordinateShifter(CoordinateShifter coordinateShifter) {
    CoordinateShifterManager.coordinateShifter =
      coordinateShifter == null ? DEFAULT : coordinateShifter;
  }

  /**
   * Check whether the current shifter is the default one.
   * @return true if using default shifter.
   */
  public static boolean isUsingDefaultShifter() {
    return coordinateShifter == DEFAULT;
  }
}
