/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.kits.geojson;

import ai.nextbillion.kits.geojson.Point;
import ai.nextbillion.kits.geojson.gson.BoundingBoxTypeAdapter;
import androidx.annotation.FloatRange;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import java.io.Serializable;

@Keep
public class BoundingBox
implements Serializable {
    private final Point southwest;
    private final Point northeast;

    public static BoundingBox fromJson(String json) {
        Gson gson = new GsonBuilder().registerTypeAdapter(BoundingBox.class, (Object)new BoundingBoxTypeAdapter()).create();
        return (BoundingBox)gson.fromJson(json, BoundingBox.class);
    }

    public static BoundingBox fromPoints(@NonNull Point southwest, @NonNull Point northeast) {
        return new BoundingBox(southwest, northeast);
    }

    @Deprecated
    public static BoundingBox fromCoordinates(@FloatRange(from=-180.0, to=180.0) double west, @FloatRange(from=-90.0, to=90.0) double south, @FloatRange(from=-180.0, to=180.0) double east, @FloatRange(from=-90.0, to=90.0) double north) {
        return BoundingBox.fromLngLats(west, south, east, north);
    }

    @Deprecated
    public static BoundingBox fromCoordinates(@FloatRange(from=-180.0, to=180.0) double west, @FloatRange(from=-90.0, to=90.0) double south, double southwestAltitude, @FloatRange(from=-180.0, to=180.0) double east, @FloatRange(from=-90.0, to=90.0) double north, double northEastAltitude) {
        return BoundingBox.fromLngLats(west, south, southwestAltitude, east, north, northEastAltitude);
    }

    public static BoundingBox fromLngLats(@FloatRange(from=-180.0, to=180.0) double west, @FloatRange(from=-90.0, to=90.0) double south, @FloatRange(from=-180.0, to=180.0) double east, @FloatRange(from=-90.0, to=90.0) double north) {
        return new BoundingBox(Point.fromLngLat(west, south), Point.fromLngLat(east, north));
    }

    public static BoundingBox fromLngLats(@FloatRange(from=-180.0, to=180.0) double west, @FloatRange(from=-90.0, to=90.0) double south, double southwestAltitude, @FloatRange(from=-180.0, to=180.0) double east, @FloatRange(from=-90.0, to=90.0) double north, double northEastAltitude) {
        return new BoundingBox(Point.fromLngLat(west, south, southwestAltitude), Point.fromLngLat(east, north, northEastAltitude));
    }

    BoundingBox(Point southwest, Point northeast) {
        if (southwest == null) {
            throw new NullPointerException("Null southwest");
        }
        this.southwest = southwest;
        if (northeast == null) {
            throw new NullPointerException("Null northeast");
        }
        this.northeast = northeast;
    }

    @NonNull
    public Point southwest() {
        return this.southwest;
    }

    @NonNull
    public Point northeast() {
        return this.northeast;
    }

    public final double west() {
        return this.southwest().longitude();
    }

    public final double south() {
        return this.southwest().latitude();
    }

    public final double east() {
        return this.northeast().longitude();
    }

    public final double north() {
        return this.northeast().latitude();
    }

    public static TypeAdapter<BoundingBox> typeAdapter(Gson gson) {
        return new BoundingBoxTypeAdapter();
    }

    public final String toJson() {
        Gson gson = new GsonBuilder().registerTypeAdapter(BoundingBox.class, (Object)new BoundingBoxTypeAdapter()).create();
        return gson.toJson((Object)this, BoundingBox.class);
    }

    public String toString() {
        return "BoundingBox{southwest=" + this.southwest + ", northeast=" + this.northeast + "}";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof BoundingBox) {
            BoundingBox that = (BoundingBox)obj;
            return this.southwest.equals(that.southwest()) && this.northeast.equals(that.northeast());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode *= 1000003;
        hashCode ^= this.southwest.hashCode();
        hashCode *= 1000003;
        return hashCode ^= this.northeast.hashCode();
    }
}

