/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.kits.geojson;

import ai.nextbillion.kits.geojson.BoundingBox;
import ai.nextbillion.kits.geojson.Geometry;
import ai.nextbillion.kits.geojson.GeometryAdapterFactory;
import ai.nextbillion.kits.geojson.gson.GeoJsonAdapterFactory;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;

@Keep
public final class GeometryCollection
implements Geometry {
    private static final String TYPE = "GeometryCollection";
    private final String type;
    private final BoundingBox bbox;
    private final List<Geometry> geometries;

    public static GeometryCollection fromJson(String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        gson.registerTypeAdapterFactory(GeometryAdapterFactory.create());
        return (GeometryCollection)gson.create().fromJson(json, GeometryCollection.class);
    }

    public static GeometryCollection fromGeometries(@NonNull List<Geometry> geometries) {
        return new GeometryCollection(TYPE, null, geometries);
    }

    public static GeometryCollection fromGeometries(@NonNull List<Geometry> geometries, @Nullable BoundingBox bbox) {
        return new GeometryCollection(TYPE, bbox, geometries);
    }

    public static GeometryCollection fromGeometry(@NonNull Geometry geometry) {
        List<Geometry> geometries = Arrays.asList(geometry);
        return new GeometryCollection(TYPE, null, geometries);
    }

    public static GeometryCollection fromGeometry(@NonNull Geometry geometry, @Nullable BoundingBox bbox) {
        List<Geometry> geometries = Arrays.asList(geometry);
        return new GeometryCollection(TYPE, bbox, geometries);
    }

    GeometryCollection(String type, @Nullable BoundingBox bbox, List<Geometry> geometries) {
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        this.type = type;
        this.bbox = bbox;
        if (geometries == null) {
            throw new NullPointerException("Null geometries");
        }
        this.geometries = geometries;
    }

    @Override
    @NonNull
    public String type() {
        return this.type;
    }

    @Override
    @Nullable
    public BoundingBox bbox() {
        return this.bbox;
    }

    @NonNull
    public List<Geometry> geometries() {
        return this.geometries;
    }

    @Override
    public String toJson() {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        gson.registerTypeAdapterFactory(GeometryAdapterFactory.create());
        return gson.create().toJson((Object)this);
    }

    public static TypeAdapter<GeometryCollection> typeAdapter(Gson gson) {
        return new GsonTypeAdapter(gson);
    }

    public String toString() {
        return "GeometryCollection{type=" + this.type + ", bbox=" + this.bbox + ", geometries=" + this.geometries + "}";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GeometryCollection) {
            GeometryCollection that = (GeometryCollection)obj;
            return this.type.equals(that.type()) && (this.bbox == null ? that.bbox() == null : this.bbox.equals(that.bbox())) && this.geometries.equals(that.geometries());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode *= 1000003;
        hashCode ^= this.type.hashCode();
        hashCode *= 1000003;
        hashCode ^= this.bbox == null ? 0 : this.bbox.hashCode();
        hashCode *= 1000003;
        return hashCode ^= this.geometries.hashCode();
    }

    static final class GsonTypeAdapter
    extends TypeAdapter<GeometryCollection> {
        private volatile TypeAdapter<String> stringTypeAdapter;
        private volatile TypeAdapter<BoundingBox> boundingBoxTypeAdapter;
        private volatile TypeAdapter<List<Geometry>> listGeometryAdapter;
        private final Gson gson;

        GsonTypeAdapter(Gson gson) {
            this.gson = gson;
        }

        public void write(JsonWriter jsonWriter, GeometryCollection object) throws IOException {
            if (object == null) {
                jsonWriter.nullValue();
                return;
            }
            jsonWriter.beginObject();
            jsonWriter.name("type");
            if (object.type() == null) {
                jsonWriter.nullValue();
            } else {
                TypeAdapter stringTypeAdapter = this.stringTypeAdapter;
                if (stringTypeAdapter == null) {
                    this.stringTypeAdapter = stringTypeAdapter = this.gson.getAdapter(String.class);
                }
                stringTypeAdapter.write(jsonWriter, (Object)object.type());
            }
            jsonWriter.name("bbox");
            if (object.bbox() == null) {
                jsonWriter.nullValue();
            } else {
                TypeAdapter boundingBoxTypeAdapter = this.boundingBoxTypeAdapter;
                if (boundingBoxTypeAdapter == null) {
                    this.boundingBoxTypeAdapter = boundingBoxTypeAdapter = this.gson.getAdapter(BoundingBox.class);
                }
                boundingBoxTypeAdapter.write(jsonWriter, (Object)object.bbox());
            }
            jsonWriter.name("geometries");
            if (object.geometries() == null) {
                jsonWriter.nullValue();
            } else {
                TypeAdapter listGeometryAdapter = this.listGeometryAdapter;
                if (listGeometryAdapter == null) {
                    TypeToken typeToken = TypeToken.getParameterized(List.class, (Type[])new Type[]{Geometry.class});
                    this.listGeometryAdapter = listGeometryAdapter = this.gson.getAdapter(typeToken);
                }
                listGeometryAdapter.write(jsonWriter, object.geometries());
            }
            jsonWriter.endObject();
        }

        public GeometryCollection read(JsonReader jsonReader) throws IOException {
            if (jsonReader.peek() == JsonToken.NULL) {
                jsonReader.nextNull();
                return null;
            }
            jsonReader.beginObject();
            String type = null;
            BoundingBox bbox = null;
            List geometries = null;
            block10: while (jsonReader.hasNext()) {
                String name = jsonReader.nextName();
                if (jsonReader.peek() == JsonToken.NULL) {
                    jsonReader.nextNull();
                    continue;
                }
                switch (name) {
                    case "type": {
                        TypeAdapter stringTypeAdapter = this.stringTypeAdapter;
                        if (stringTypeAdapter == null) {
                            this.stringTypeAdapter = stringTypeAdapter = this.gson.getAdapter(String.class);
                        }
                        type = (String)stringTypeAdapter.read(jsonReader);
                        continue block10;
                    }
                    case "bbox": {
                        TypeAdapter boundingBoxTypeAdapter = this.boundingBoxTypeAdapter;
                        if (boundingBoxTypeAdapter == null) {
                            this.boundingBoxTypeAdapter = boundingBoxTypeAdapter = this.gson.getAdapter(BoundingBox.class);
                        }
                        bbox = (BoundingBox)boundingBoxTypeAdapter.read(jsonReader);
                        continue block10;
                    }
                    case "geometries": {
                        TypeAdapter listGeometryAdapter = this.listGeometryAdapter;
                        if (listGeometryAdapter == null) {
                            TypeToken typeToken = TypeToken.getParameterized(List.class, (Type[])new Type[]{Geometry.class});
                            this.listGeometryAdapter = listGeometryAdapter = this.gson.getAdapter(typeToken);
                        }
                        geometries = (List)listGeometryAdapter.read(jsonReader);
                        continue block10;
                    }
                }
                jsonReader.skipValue();
            }
            jsonReader.endObject();
            return new GeometryCollection(type == null ? GeometryCollection.TYPE : type, bbox, geometries);
        }
    }
}

