/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.kits.geojson;

import ai.nextbillion.kits.geojson.BaseGeometryTypeAdapter;
import ai.nextbillion.kits.geojson.BoundingBox;
import ai.nextbillion.kits.geojson.CoordinateContainer;
import ai.nextbillion.kits.geojson.ListOfPointCoordinatesTypeAdapter;
import ai.nextbillion.kits.geojson.MultiPoint;
import ai.nextbillion.kits.geojson.Point;
import ai.nextbillion.kits.geojson.gson.GeoJsonAdapterFactory;
import ai.nextbillion.kits.geojson.utils.PolylineUtils;
import androidx.annotation.Keep;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

@Keep
public final class LineString
implements CoordinateContainer<List<Point>> {
    private static final String TYPE = "LineString";
    private final String type;
    private final BoundingBox bbox;
    private final List<Point> coordinates;

    public static LineString fromJson(String json) {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return (LineString)gson.create().fromJson(json, LineString.class);
    }

    public static LineString fromLngLats(@NonNull MultiPoint multiPoint) {
        return new LineString(TYPE, null, (List<Point>)multiPoint.coordinates());
    }

    public static LineString fromLngLats(@NonNull List<Point> points) {
        return new LineString(TYPE, null, points);
    }

    public static LineString fromLngLats(@NonNull List<Point> points, @Nullable BoundingBox bbox) {
        return new LineString(TYPE, bbox, points);
    }

    public static LineString fromLngLats(@NonNull MultiPoint multiPoint, @Nullable BoundingBox bbox) {
        return new LineString(TYPE, bbox, (List<Point>)multiPoint.coordinates());
    }

    LineString(String type, @Nullable BoundingBox bbox, List<Point> coordinates) {
        if (type == null) {
            throw new NullPointerException("Null type");
        }
        this.type = type;
        this.bbox = bbox;
        if (coordinates == null) {
            throw new NullPointerException("Null coordinates");
        }
        this.coordinates = coordinates;
    }

    static LineString fromLngLats(double[][] coordinates) {
        ArrayList<Point> converted = new ArrayList<Point>(coordinates.length);
        for (int i = 0; i < coordinates.length; ++i) {
            converted.add(Point.fromLngLat(coordinates[i]));
        }
        return LineString.fromLngLats(converted);
    }

    public static LineString fromPolyline(@NonNull String polyline, int precision) {
        return LineString.fromLngLats(PolylineUtils.decode(polyline, precision), null);
    }

    @Override
    @NonNull
    public String type() {
        return this.type;
    }

    @Override
    @Nullable
    public BoundingBox bbox() {
        return this.bbox;
    }

    @Override
    @NonNull
    public List<Point> coordinates() {
        return this.coordinates;
    }

    @Override
    public String toJson() {
        GsonBuilder gson = new GsonBuilder();
        gson.registerTypeAdapterFactory(GeoJsonAdapterFactory.create());
        return gson.create().toJson((Object)this);
    }

    public String toPolyline(int precision) {
        return PolylineUtils.encode((List<Point>)this.coordinates(), precision);
    }

    public static TypeAdapter<LineString> typeAdapter(Gson gson) {
        return new GsonTypeAdapter(gson);
    }

    public String toString() {
        return "LineString{type=" + this.type + ", bbox=" + this.bbox + ", coordinates=" + this.coordinates + "}";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof LineString) {
            LineString that = (LineString)obj;
            return this.type.equals(that.type()) && (this.bbox == null ? that.bbox() == null : this.bbox.equals(that.bbox())) && this.coordinates.equals(that.coordinates());
        }
        return false;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode *= 1000003;
        hashCode ^= this.type.hashCode();
        hashCode *= 1000003;
        hashCode ^= this.bbox == null ? 0 : this.bbox.hashCode();
        hashCode *= 1000003;
        return hashCode ^= this.coordinates.hashCode();
    }

    static final class GsonTypeAdapter
    extends BaseGeometryTypeAdapter<LineString, List<Point>> {
        GsonTypeAdapter(Gson gson) {
            super(gson, new ListOfPointCoordinatesTypeAdapter());
        }

        public void write(JsonWriter jsonWriter, LineString object) throws IOException {
            this.writeCoordinateContainer(jsonWriter, object);
        }

        public LineString read(JsonReader jsonReader) throws IOException {
            return (LineString)this.readCoordinateContainer(jsonReader);
        }

        @Override
        CoordinateContainer<List<Point>> createCoordinateContainer(String type, BoundingBox bbox, List<Point> coordinates) {
            return new LineString(type == null ? LineString.TYPE : type, bbox, coordinates);
        }
    }
}

