/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.kits.geojson.gson;

import ai.nextbillion.kits.geojson.BoundingBox;
import ai.nextbillion.kits.geojson.Feature;
import ai.nextbillion.kits.geojson.FeatureCollection;
import ai.nextbillion.kits.geojson.GeometryCollection;
import ai.nextbillion.kits.geojson.LineString;
import ai.nextbillion.kits.geojson.MultiLineString;
import ai.nextbillion.kits.geojson.MultiPoint;
import ai.nextbillion.kits.geojson.MultiPolygon;
import ai.nextbillion.kits.geojson.Point;
import ai.nextbillion.kits.geojson.Polygon;
import androidx.annotation.Keep;
import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;

@Keep
public abstract class GeoJsonAdapterFactory
implements TypeAdapterFactory {
    public static TypeAdapterFactory create() {
        return new GeoJsonAdapterFactoryIml();
    }

    public static final class GeoJsonAdapterFactoryIml
    extends GeoJsonAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            Class rawType = type.getRawType();
            if (BoundingBox.class.isAssignableFrom(rawType)) {
                return BoundingBox.typeAdapter(gson);
            }
            if (Feature.class.isAssignableFrom(rawType)) {
                return Feature.typeAdapter(gson);
            }
            if (FeatureCollection.class.isAssignableFrom(rawType)) {
                return FeatureCollection.typeAdapter(gson);
            }
            if (GeometryCollection.class.isAssignableFrom(rawType)) {
                return GeometryCollection.typeAdapter(gson);
            }
            if (LineString.class.isAssignableFrom(rawType)) {
                return LineString.typeAdapter(gson);
            }
            if (MultiLineString.class.isAssignableFrom(rawType)) {
                return MultiLineString.typeAdapter(gson);
            }
            if (MultiPoint.class.isAssignableFrom(rawType)) {
                return MultiPoint.typeAdapter(gson);
            }
            if (MultiPolygon.class.isAssignableFrom(rawType)) {
                return MultiPolygon.typeAdapter(gson);
            }
            if (Polygon.class.isAssignableFrom(rawType)) {
                return Polygon.typeAdapter(gson);
            }
            if (Point.class.isAssignableFrom(rawType)) {
                return Point.typeAdapter(gson);
            }
            return null;
        }
    }
}

