/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.kits.geojson.shifter;

import ai.nextbillion.kits.geojson.Point;
import ai.nextbillion.kits.geojson.shifter.CoordinateShifter;
import java.util.Arrays;
import java.util.List;

public final class CoordinateShifterManager {
    private static final CoordinateShifter DEFAULT;
    private static volatile CoordinateShifter coordinateShifter;

    public static CoordinateShifter getCoordinateShifter() {
        return coordinateShifter;
    }

    public static void setCoordinateShifter(CoordinateShifter coordinateShifter) {
        CoordinateShifterManager.coordinateShifter = coordinateShifter == null ? DEFAULT : coordinateShifter;
    }

    public static boolean isUsingDefaultShifter() {
        return coordinateShifter == DEFAULT;
    }

    static {
        coordinateShifter = DEFAULT = new CoordinateShifter(){

            @Override
            public List<Double> shiftLonLat(double lon, double lat) {
                return Arrays.asList(lon, lat);
            }

            @Override
            public List<Double> shiftLonLatAlt(double lon, double lat, double alt) {
                return Double.isNaN(alt) ? Arrays.asList(lon, lat) : Arrays.asList(lon, lat, alt);
            }

            @Override
            public List<Double> unshiftPoint(Point point) {
                return point.coordinates();
            }

            @Override
            public List<Double> unshiftPoint(List<Double> coordinates) {
                return coordinates;
            }
        };
    }
}

