/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.kits.turf;

import ai.nextbillion.kits.geojson.Feature;
import ai.nextbillion.kits.geojson.FeatureCollection;
import ai.nextbillion.kits.geojson.GeoJson;
import ai.nextbillion.kits.geojson.Point;
import ai.nextbillion.kits.turf.TurfException;
import ai.nextbillion.kits.turf.TurfMeta;

public final class TurfAssertions {
    private TurfAssertions() {
    }

    @Deprecated
    public static Point getCoord(Feature obj) {
        return TurfMeta.getCoord(obj);
    }

    public static void geojsonType(GeoJson value, String type, String name) {
        if (type == null || type.length() == 0 || name == null || name.length() == 0) {
            throw new TurfException("Type and name required");
        }
        if (value == null || !value.type().equals(type)) {
            throw new TurfException("Invalid input to " + name + ": must be a " + type + ", given " + (value != null ? value.type() : " null"));
        }
    }

    public static void featureOf(Feature feature, String type, String name) {
        if (name == null || name.length() == 0) {
            throw new TurfException(".featureOf() requires a name");
        }
        if (feature == null || !feature.type().equals("Feature") || feature.geometry() == null) {
            throw new TurfException(String.format("Invalid input to %s, Feature with geometry required", name));
        }
        if (feature.geometry() == null || !feature.geometry().type().equals(type)) {
            throw new TurfException(String.format("Invalid input to %s: must be a %s, given %s", name, type, feature.geometry().type()));
        }
    }

    public static void collectionOf(FeatureCollection featureCollection, String type, String name) {
        if (name == null || name.length() == 0) {
            throw new TurfException("collectionOf() requires a name");
        }
        if (featureCollection == null || !featureCollection.type().equals("FeatureCollection") || featureCollection.features() == null) {
            throw new TurfException(String.format("Invalid input to %s, FeatureCollection required", name));
        }
        for (Feature feature : featureCollection.features()) {
            if (feature == null || !feature.type().equals("Feature") || feature.geometry() == null) {
                throw new TurfException(String.format("Invalid input to %s, Feature with geometry required", name));
            }
            if (feature.geometry() != null && feature.geometry().type().equals(type)) continue;
            throw new TurfException(String.format("Invalid input to %s: must be a %s, given %s", name, type, feature.geometry().type()));
        }
    }
}

