/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.kits.turf;

import ai.nextbillion.kits.geojson.Point;
import ai.nextbillion.kits.turf.TurfMeasurement;
import androidx.annotation.NonNull;
import java.util.List;

public class TurfClassification {
    private TurfClassification() {
    }

    @NonNull
    public static Point nearestPoint(@NonNull Point targetPoint, @NonNull List<Point> points) {
        if (points.isEmpty()) {
            return targetPoint;
        }
        Point nearestPoint = points.get(0);
        double minDist = Double.POSITIVE_INFINITY;
        for (Point point : points) {
            double distanceToPoint = TurfMeasurement.distance(targetPoint, point);
            if (!(distanceToPoint < minDist)) continue;
            nearestPoint = point;
            minDist = distanceToPoint;
        }
        return nearestPoint;
    }
}

