/*
 * Decompiled with CFR 0.152.
 */
package ai.nextbillion.kits.turf;

import ai.nextbillion.kits.geojson.Feature;
import ai.nextbillion.kits.geojson.FeatureCollection;
import ai.nextbillion.kits.geojson.Geometry;
import ai.nextbillion.kits.geojson.LineString;
import ai.nextbillion.kits.geojson.MultiLineString;
import ai.nextbillion.kits.geojson.MultiPoint;
import ai.nextbillion.kits.geojson.MultiPolygon;
import ai.nextbillion.kits.geojson.Point;
import ai.nextbillion.kits.geojson.Polygon;
import ai.nextbillion.kits.turf.TurfConstants;
import ai.nextbillion.kits.turf.TurfException;
import ai.nextbillion.kits.turf.TurfMeta;
import androidx.annotation.FloatRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class TurfConversion {
    private static final Map<String, Double> FACTORS = new HashMap<String, Double>();

    private TurfConversion() {
    }

    public static double lengthToDegrees(double distance, @TurfConstants.TurfUnitCriteria String units) {
        return TurfConversion.radiansToDegrees(TurfConversion.lengthToRadians(distance, units));
    }

    public static double degreesToRadians(double degrees) {
        double radians = degrees % 360.0;
        return radians * Math.PI / 180.0;
    }

    public static double radiansToDegrees(double radians) {
        double degrees = radians % (Math.PI * 2);
        return degrees * 180.0 / Math.PI;
    }

    public static double radiansToLength(double radians) {
        return TurfConversion.radiansToLength(radians, "kilometers");
    }

    public static double radiansToLength(double radians, @NonNull @TurfConstants.TurfUnitCriteria String units) {
        return radians * FACTORS.get(units);
    }

    public static double lengthToRadians(double distance) {
        return TurfConversion.lengthToRadians(distance, "kilometers");
    }

    public static double lengthToRadians(double distance, @NonNull @TurfConstants.TurfUnitCriteria String units) {
        return distance / FACTORS.get(units);
    }

    public static double convertLength(@FloatRange(from=0.0) double distance, @NonNull @TurfConstants.TurfUnitCriteria String originalUnit) {
        return TurfConversion.convertLength(distance, originalUnit, "kilometers");
    }

    public static double convertLength(@FloatRange(from=0.0) double distance, @NonNull @TurfConstants.TurfUnitCriteria String originalUnit, @Nullable @TurfConstants.TurfUnitCriteria String finalUnit) {
        if (finalUnit == null) {
            finalUnit = "kilometers";
        }
        return TurfConversion.radiansToLength(TurfConversion.lengthToRadians(distance, originalUnit), finalUnit);
    }

    public static FeatureCollection explode(@NonNull FeatureCollection featureCollection) {
        ArrayList<Feature> finalFeatureList = new ArrayList<Feature>();
        for (Point singlePoint : TurfMeta.coordAll(featureCollection, true)) {
            finalFeatureList.add(Feature.fromGeometry((Geometry)singlePoint));
        }
        return FeatureCollection.fromFeatures(finalFeatureList);
    }

    public static FeatureCollection explode(@NonNull Feature feature) {
        ArrayList<Feature> finalFeatureList = new ArrayList<Feature>();
        for (Point singlePoint : TurfMeta.coordAll(feature, true)) {
            finalFeatureList.add(Feature.fromGeometry((Geometry)singlePoint));
        }
        return FeatureCollection.fromFeatures(finalFeatureList);
    }

    public static Feature polygonToLine(@NonNull Feature feature) {
        return TurfConversion.polygonToLine(feature, null);
    }

    public static Feature polygonToLine(@NonNull Feature feature, @Nullable JsonObject properties) {
        Geometry geometry = feature.geometry();
        if (geometry instanceof Polygon) {
            return TurfConversion.polygonToLine((Polygon)geometry, properties != null ? properties : (feature.type().equals("Feature") ? feature.properties() : new JsonObject()));
        }
        throw new TurfException("Feature's geometry must be Polygon");
    }

    public static Feature polygonToLine(@NonNull Polygon polygon) {
        return TurfConversion.polygonToLine(polygon, null);
    }

    public static FeatureCollection polygonToLine(@NonNull MultiPolygon multiPolygon) {
        return TurfConversion.polygonToLine(multiPolygon, null);
    }

    public static Feature polygonToLine(@NonNull Polygon polygon, @Nullable JsonObject properties) {
        return TurfConversion.coordsToLine(polygon.coordinates(), properties);
    }

    public static FeatureCollection polygonToLine(@NonNull MultiPolygon multiPolygon, @Nullable JsonObject properties) {
        List coordinates = multiPolygon.coordinates();
        ArrayList<Feature> finalFeatureList = new ArrayList<Feature>();
        for (List polygonCoordinates : coordinates) {
            finalFeatureList.add(TurfConversion.coordsToLine(polygonCoordinates, properties));
        }
        return FeatureCollection.fromFeatures(finalFeatureList);
    }

    public static FeatureCollection multiPolygonToLine(@NonNull Feature feature) {
        return TurfConversion.multiPolygonToLine(feature, null);
    }

    public static FeatureCollection multiPolygonToLine(@NonNull Feature feature, @Nullable JsonObject properties) {
        Geometry geometry = feature.geometry();
        if (geometry instanceof MultiPolygon) {
            return TurfConversion.polygonToLine((MultiPolygon)geometry, properties != null ? properties : (feature.type().equals("Feature") ? feature.properties() : new JsonObject()));
        }
        throw new TurfException("Feature's geometry must be MultiPolygon");
    }

    @Nullable
    private static Feature coordsToLine(@NonNull List<List<Point>> coordinates, @Nullable JsonObject properties) {
        if (coordinates.size() > 1) {
            return Feature.fromGeometry((Geometry)MultiLineString.fromLngLats(coordinates), (JsonObject)properties);
        }
        if (coordinates.size() == 1) {
            LineString lineString = LineString.fromLngLats(coordinates.get(0));
            return Feature.fromGeometry((Geometry)lineString, (JsonObject)properties);
        }
        return null;
    }

    public static FeatureCollection combine(@NonNull FeatureCollection originalFeatureCollection) {
        if (originalFeatureCollection.features() == null) {
            throw new TurfException("Your FeatureCollection is null.");
        }
        if (originalFeatureCollection.features().size() == 0) {
            throw new TurfException("Your FeatureCollection doesn't have any Feature objects in it.");
        }
        ArrayList<Point> pointList = new ArrayList<Point>(0);
        ArrayList<LineString> lineStringList = new ArrayList<LineString>(0);
        ArrayList<Polygon> polygonList = new ArrayList<Polygon>(0);
        for (Feature singleFeature : originalFeatureCollection.features()) {
            Geometry singleFeatureGeometry = singleFeature.geometry();
            if (singleFeatureGeometry instanceof Point || singleFeatureGeometry instanceof MultiPoint) {
                if (singleFeatureGeometry instanceof Point) {
                    pointList.add((Point)singleFeatureGeometry);
                    continue;
                }
                pointList.addAll(((MultiPoint)singleFeatureGeometry).coordinates());
                continue;
            }
            if (singleFeatureGeometry instanceof LineString || singleFeatureGeometry instanceof MultiLineString) {
                if (singleFeatureGeometry instanceof LineString) {
                    lineStringList.add((LineString)singleFeatureGeometry);
                    continue;
                }
                lineStringList.addAll(((MultiLineString)singleFeatureGeometry).lineStrings());
                continue;
            }
            if (!(singleFeatureGeometry instanceof Polygon) && !(singleFeatureGeometry instanceof MultiPolygon)) continue;
            if (singleFeatureGeometry instanceof Polygon) {
                polygonList.add((Polygon)singleFeatureGeometry);
                continue;
            }
            polygonList.addAll(((MultiPolygon)singleFeatureGeometry).polygons());
        }
        ArrayList<Feature> finalFeatureList = new ArrayList<Feature>(0);
        if (!pointList.isEmpty()) {
            finalFeatureList.add(Feature.fromGeometry((Geometry)MultiPoint.fromLngLats(pointList)));
        }
        if (!lineStringList.isEmpty()) {
            finalFeatureList.add(Feature.fromGeometry((Geometry)MultiLineString.fromLineStrings(lineStringList)));
        }
        if (!polygonList.isEmpty()) {
            finalFeatureList.add(Feature.fromGeometry((Geometry)MultiPolygon.fromPolygons(polygonList)));
        }
        return finalFeatureList.isEmpty() ? originalFeatureCollection : FeatureCollection.fromFeatures(finalFeatureList);
    }

    static {
        FACTORS.put("miles", 3960.0);
        FACTORS.put("nauticalmiles", 3441.145);
        FACTORS.put("degrees", 57.2957795);
        FACTORS.put("radians", 1.0);
        FACTORS.put("inches", 2.509056E8);
        FACTORS.put("yards", 6969600.0);
        FACTORS.put("meters", 6373000.0);
        FACTORS.put("centimeters", 6.373E8);
        FACTORS.put("kilometers", 6373.0);
        FACTORS.put("feet", 2.090879265E7);
        FACTORS.put("centimetres", 6.373E8);
        FACTORS.put("metres", 6373000.0);
        FACTORS.put("kilometres", 6373.0);
    }
}

